/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ObjectScanner {
    private String excludeMatch = "_.*[^_]$";
    private ObjectScannerHandler handler;

    public ObjectScanner() {
    }

    public ObjectScanner(ObjectScannerHandler h) {
        this.handler = h;
    }

    public void scan(Object data) {
        if (this.handler == null) {
            this.handler = new DefaultHandler();
        }
        this.handler.startDocument();
        this.scanObject(null, data, 0);
        this.handler.endDocument();
    }

    public void scanObject(String name, Object o, int pos) {
        if (o == null) {
            this.handler.property(name, o, pos);
        } else if (o instanceof Map) {
            Map map = (Map)o;
            if (map.isEmpty()) {
                this.handler.emptyElement(name, map, pos);
            } else {
                this.handler.startElement(name, pos);
                int i = 0;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry m;
                    Map.Entry me = m = iterator.next();
                    String key = me.getKey() + "";
                    if (this.excludeMatch != null && key.matches(this.excludeMatch)) continue;
                    Object value = me.getValue();
                    this.scanObject(key, value, i++);
                }
                this.handler.endElement(name);
            }
        } else if (o instanceof List || o.getClass().isArray()) {
            List<Object> list = null;
            list = o.getClass().isArray() ? Arrays.asList((Object[])o) : (List<Object>)o;
            if (list.isEmpty()) {
                this.handler.emptyElement(name, list, pos);
            } else {
                this.handler.startElement(name, pos);
                int i = 0;
                for (Object item : list) {
                    this.scanObject(null, item, i++);
                }
                this.handler.endElement(name);
            }
        } else {
            this.handler.property(name, o, pos);
        }
    }

    public String getExcludeMatch() {
        return this.excludeMatch;
    }

    public void setExcludeMatch(String excludeMatch) {
        this.excludeMatch = excludeMatch;
    }

    public static class DefaultHandler
    implements ObjectScannerHandler {
        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String name, int pos) {
        }

        @Override
        public void property(String name, Object value, int pos) {
        }

        @Override
        public void endElement(String name) {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void emptyElement(String name, Object value, int pos) {
        }
    }

    public static interface ObjectScannerHandler {
        public void startDocument();

        public void emptyElement(String var1, Object var2, int var3);

        public void startElement(String var1, int var2);

        public void property(String var1, Object var2, int var3);

        public void endElement(String var1);

        public void endDocument();
    }
}

