/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TimeUtil {
    private static SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static boolean checkSchedule(Date d, String timePattern) {
        try {
            ScheduleBean p = new ScheduleBean(timePattern);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            int dow = cal.get(7);
            if (dow == 2 && !p.isMon()) {
                return false;
            }
            if (dow == 3 && !p.isTue()) {
                return false;
            }
            if (dow == 4 && !p.isWed()) {
                return false;
            }
            if (dow == 5 && !p.isThu()) {
                return false;
            }
            if (dow == 6 && !p.isFri()) {
                return false;
            }
            if (dow == 7 && !p.isSat()) {
                return false;
            }
            if (dow == 1 && !p.isSun()) {
                return false;
            }
            String strDate = formatDay.format(d);
            Date dfrom = dformat.parse(strDate + " " + p.getFromTime());
            Date dto = dformat.parse(strDate + " " + p.getToTime());
            if (d.before(dfrom)) {
                return false;
            }
            return !d.after(dto);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void parseToDay(String pattern, ParseHandler handler) {
        ScheduleBean bean = new ScheduleBean(pattern);
        String dummyDate = "0000-00-00";
        Timestamp start = Timestamp.valueOf(dummyDate + " " + bean.getFromTime() + ":00");
        Timestamp end = Timestamp.valueOf(dummyDate + " " + bean.getToTime() + ":00");
        if (bean.isMon()) {
            handler.handle("M", start, end);
        }
        if (bean.isTue()) {
            handler.handle("T", start, end);
        }
        if (bean.isWed()) {
            handler.handle("W", start, end);
        }
        if (bean.isThu()) {
            handler.handle("Th", start, end);
        }
        if (bean.isFri()) {
            handler.handle("F", start, end);
        }
        if (bean.isSat()) {
            handler.handle("S", start, end);
        }
        if (bean.isSun()) {
            handler.handle("Su", start, end);
        }
    }

    public static List<Map> parseToDayListMap(String pattern) {
        MapListParseHandler h = new MapListParseHandler();
        TimeUtil.parseToDay(pattern, h);
        return h.getList();
    }

    public static class MapListParseHandler
    implements ParseHandler {
        private List<Map> list = new ArrayList<Map>();

        @Override
        public void handle(String dow, Timestamp from, Timestamp to) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("day", dow);
            m.put("timefrom", from);
            m.put("timeto", to);
            this.list.add(m);
        }

        public List<Map> getList() {
            return this.list;
        }
    }

    public static interface ParseHandler {
        public void handle(String var1, Timestamp var2, Timestamp var3);
    }

    public static class ScheduleBean {
        private String fromTime;
        private String toTime;
        private boolean mon;
        private boolean tue;
        private boolean wed;
        private boolean thu;
        private boolean fri;
        private boolean sat;
        private boolean sun;

        public ScheduleBean() {
        }

        public ScheduleBean(String pattern) {
            this.parse(pattern);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.fromTime);
            sb.append("-");
            sb.append(this.toTime);
            sb.append(" ");
            if (this.mon) {
                sb.append("M");
            }
            if (this.tue) {
                sb.append("T");
            }
            if (this.wed) {
                sb.append("W");
            }
            if (this.thu) {
                sb.append("Th");
            }
            if (this.fri) {
                sb.append("F");
            }
            if (this.sat) {
                sb.append("S");
            }
            if (this.sun) {
                sb.append("Su");
            }
            return sb.toString();
        }

        private int findDayInList(String m, String[] days) {
            for (int i = 0; i < days.length; ++i) {
                if (!days[i].equals(m)) continue;
                return i;
            }
            return -1;
        }

        private void parse(String pattern) {
            if (!pattern.matches("\\d\\d:\\d\\d-\\d\\d:\\d\\d (M|T|W|Th|F|S|Su|-).*")) {
                throw new RuntimeException("Pattern is incorrect. Must follow for example  ##:##-##:## MWF");
            }
            this.fromTime = pattern.substring(0, pattern.indexOf("-"));
            this.toTime = pattern.substring(pattern.indexOf("-") + 1, pattern.indexOf(" "));
            String days = pattern.substring(pattern.indexOf(" ") + 1);
            if (days.contains("-")) {
                String[] arr = days.split("-");
                String max = arr[1];
                String[] list = new String[]{"M", "T", "W", "Th", "F", "S", "Su"};
                int imin = this.findDayInList(arr[0], list);
                int imax = this.findDayInList(arr[1], list);
                StringBuffer sb = new StringBuffer();
                for (int i = imin; i <= imax; ++i) {
                    sb.append(list[i]);
                }
                days = sb.toString();
            }
            if (days.contains("M")) {
                this.mon = true;
            }
            if (days.matches(".*T(?!h).*")) {
                this.tue = true;
            }
            if (days.contains("W")) {
                this.wed = true;
            }
            if (days.contains("Th")) {
                this.thu = true;
            }
            if (days.contains("F")) {
                this.fri = true;
            }
            if (days.matches(".*S(?!u).*")) {
                this.sat = true;
            }
            if (days.contains("Su")) {
                this.sun = true;
            }
        }

        public String getFromTime() {
            return this.fromTime;
        }

        public String getToTime() {
            return this.toTime;
        }

        public boolean isMon() {
            return this.mon;
        }

        public boolean isTue() {
            return this.tue;
        }

        public boolean isWed() {
            return this.wed;
        }

        public boolean isThu() {
            return this.thu;
        }

        public boolean isFri() {
            return this.fri;
        }

        public boolean isSat() {
            return this.sat;
        }

        public boolean isSun() {
            return this.sun;
        }

        public void setFromTime(String fromTime) {
            this.fromTime = fromTime;
        }

        public void setToTime(String toTime) {
            this.toTime = toTime;
        }

        public void setMon(boolean mon) {
            this.mon = mon;
        }

        public void setTue(boolean tue) {
            this.tue = tue;
        }

        public void setWed(boolean wed) {
            this.wed = wed;
        }

        public void setThu(boolean thu) {
            this.thu = thu;
        }

        public void setFri(boolean fri) {
            this.fri = fri;
        }

        public void setSat(boolean sat) {
            this.sat = sat;
        }

        public void setSun(boolean sun) {
            this.sun = sun;
        }
    }
}

