/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class URLDirectory {
    private URL url;

    public URLDirectory(URL u) {
        this.url = u;
    }

    public URL[] list(URLFilter filter) {
        return this.list(filter, null);
    }

    public URL[] list(URLFilter filter, ClassLoader loader) {
        try {
            ArrayList<URL> list = new ArrayList<URL>();
            String s = this.url.toString() + "";
            URLConnection conn = this.url.openConnection();
            if (conn instanceof JarURLConnection) {
                JarURLConnection jurl = (JarURLConnection)conn;
                JarFile jf = jurl.getJarFile();
                String dirName = s.substring(s.indexOf("!") + 1);
                String pattern = dirName + "/[^/]*(/|.)$";
                String contextPart = s.substring(0, s.indexOf("!"));
                Enumeration<JarEntry> ee = jf.entries();
                while (ee.hasMoreElements()) {
                    JarEntry je = ee.nextElement();
                    if (!("/" + je.getName()).matches(pattern)) continue;
                    String spath = contextPart + "!/" + je.getName();
                    URL u = new URL(spath);
                    if (filter != null && !filter.accept(u, u.getPath())) continue;
                    list.add(u);
                }
            } else {
                if (conn instanceof HttpURLConnection) {
                    throw new Exception("Http URL Connection is not supported at this time.");
                }
                File f = new File(this.url.getFile());
                if (f.isDirectory()) {
                    File[] files = f.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        URL u = files[i].toURI().toURL();
                        if (filter != null && !filter.accept(u, u.getPath())) continue;
                        list.add(u);
                    }
                }
            }
            return list.toArray(new URL[0]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            System.out.println("URL DIRECTORY ERROR " + ex.getMessage());
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void scanFiles(URL u, int maxLevels, URLScanHandler handler) {
        handler.start();
        URLDirectory._scanFileDir(u, 0, maxLevels, handler);
        handler.end();
    }

    private static void _scanFileDir(URL url, int i, int maxLevels, URLScanHandler handler) {
        if (i > maxLevels) {
            return;
        }
        handler.handle(url, i);
        handler.startChildren(++i);
        URLDirectory dir = new URLDirectory(url);
        for (URL u : dir.list(null)) {
            URLDirectory._scanFileDir(u, i, maxLevels, handler);
        }
        handler.endChildren(i);
    }

    public static interface URLScanHandler {
        public void start();

        public void startChildren(int var1);

        public void handle(URL var1, int var2);

        public void endChildren(int var1);

        public void end();
    }

    public static interface URLFilter {
        public boolean accept(URL var1, String var2);
    }
}

