/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.Service;
import com.rameses.util.URLStreamHandler;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class URLStreamHandlers {
    private static final URLStreamHandlers instance = new URLStreamHandlers();
    private static final Object LOCKED = new Object();
    private Map<String, Object> properties;
    private Map<String, URLStreamHandlerProxy> handlers;
    private URLStreamHandlerFactoryImpl factory;
    private ClassLoader cloader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClassLoader(ClassLoader loader) {
        Object object = LOCKED;
        synchronized (object) {
            instance.setClassLoaderImpl(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Object object = LOCKED;
        synchronized (object) {
            instance.loadImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLStreamHandlerFactory getFactory() {
        Object object = LOCKED;
        synchronized (object) {
            return instance.getFactoryImpl();
        }
    }

    public static Object getProperty(String name) {
        return URLStreamHandlers.instance.properties.get(name);
    }

    public static void setProperty(String name, Object value) {
        if (name != null && name.trim().length() > 0) {
            URLStreamHandlers.instance.properties.put(name, value);
        }
    }

    private URLStreamHandlers() {
        this.setClassLoaderImpl(null);
        this.handlers = new HashMap<String, URLStreamHandlerProxy>();
        this.properties = new HashMap<String, Object>();
        this.factory = new URLStreamHandlerFactoryImpl();
    }

    private void setClassLoaderImpl(ClassLoader cloader) {
        this.cloader = cloader;
    }

    private void loadImpl() {
        this.loadImpl(this.getClass().getClassLoader());
        this.loadImpl(this.cloader);
    }

    private void loadImpl(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        Iterator itr = Service.providers(URLStreamHandler.class, loader);
        while (itr.hasNext()) {
            URLStreamHandler handler = (URLStreamHandler)itr.next();
            String protocol = handler.getProtocol();
            if (protocol == null || protocol.trim().length() <= 0) continue;
            String sname = protocol.toLowerCase();
            URLStreamHandlerProxy proxy = this.handlers.get(sname);
            if (proxy == null) {
                proxy = new URLStreamHandlerProxy(sname);
                proxy.setClassLoader(this.cloader);
                this.handlers.put(sname, proxy);
            }
            proxy.add(handler);
        }
    }

    private URLStreamHandlerFactory getFactoryImpl() {
        return this.factory;
    }

    public URLStreamHandler get(String sname) {
        if (sname != null) {
            return this.handlers.get(sname.toLowerCase());
        }
        return null;
    }

    private class URLStreamHandlerFactoryImpl
    implements URLStreamHandlerFactory {
        private URLStreamHandlers root;

        private URLStreamHandlerFactoryImpl() {
            this.root = URLStreamHandlers.this;
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            URLStreamHandlerProxy proxy = (URLStreamHandlerProxy)this.root.get(protocol);
            if (proxy != null) {
                proxy.setClassLoader(this.root.cloader);
            }
            return proxy;
        }
    }

    private class URLStreamHandlerProxy
    extends URLStreamHandler {
        private String protocol;
        private List<URLStreamHandler> handlers;

        URLStreamHandlerProxy(String protocol) {
            this.protocol = protocol;
            this.handlers = new ArrayList<URLStreamHandler>();
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }

        public void add(URLStreamHandler o) {
            if (o != null && !this.handlers.contains(o)) {
                this.handlers.add(o);
                Collections.sort(this.handlers, new Comparator<URLStreamHandler>(){

                    @Override
                    public int compare(URLStreamHandler o1, URLStreamHandler o2) {
                        if (o1 == null || o2 == null) {
                            return 0;
                        }
                        if (o1.getIndex() > o2.getIndex()) {
                            return 1;
                        }
                        if (o1.getIndex() < o2.getIndex()) {
                            return -1;
                        }
                        return 0;
                    }
                });
            }
        }

        public void removeAll() {
            this.handlers.clear();
        }

        @Override
        public URL getResource(String spath) {
            for (URLStreamHandler handler : this.handlers) {
                handler.setClassLoader(this.getClassLoader());
                URL result = handler.getResource(spath);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }
}

