/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.BitmapCharacter;
import com.topaz.sigplus.util.CharacterMap;
import com.topaz.sigplus.util.LCDGraphicBitmapType;
import com.topaz.sigplus.util.SigInputStream;
import com.topaz.sigplus.util.TabletInterface;
import java.io.FileInputStream;
import java.io.IOException;

public class LCDTextGraphicsSupport {
    TabletInterface tab;

    public LCDTextGraphicsSupport(TabletInterface tabIf) {
        this.tab = tabIf;
    }

    public boolean lcdWriteImage(int dest, int mode, int xPos, int yPos, int xSize, int ySize, byte[] imageData) {
        LCDGraphicBitmapType gmp = new LCDGraphicBitmapType();
        if (mode != 0 && mode != 1) {
            if (imageData != null) {
                gmp.init(xPos, yPos, xSize, ySize);
                int i = 0;
                while (i < xSize) {
                    int j = 0;
                    while (j < ySize) {
                        byte pixel = imageData[j * xSize + i];
                        if (pixel != 0) {
                            gmp.setPixel(i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                xSize = 16;
                ySize = 16;
                xPos = 0;
                yPos = 0;
                gmp.init(xPos, yPos, xSize, ySize);
                int i = 0;
                while (i < gmp.bufferSize) {
                    gmp.buffer[i] = -1;
                    ++i;
                }
            }
        } else {
            gmp.init(xPos, yPos, xSize, ySize);
            gmp.bufferSize = 0;
        }
        boolean oldStatus = this.tab.tabletStatus;
        if (!oldStatus) {
            this.tab.openTablet();
        }
        boolean rv = this.tab.lcdSendGraphic(dest, mode, gmp.xPosNew, yPos, gmp.xSizeNew, ySize, gmp.buffer, gmp.bufferSize);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tab.lcdTabletSetup();
        if (!oldStatus) {
            this.tab.closeTablet();
        }
        return rv;
    }

    public boolean lcdWriteImageFile(int dest, int mode, int xPos, int yPos, String fileName) {
        byte[] buffer;
        try {
            FileInputStream file = new FileInputStream(fileName);
            buffer = new byte[file.available()];
            file.read(buffer);
            file.close();
        }
        catch (IOException e) {
            return false;
        }
        SigInputStream imageStream = new SigInputStream(buffer);
        int xSize = imageStream.readBinaryShort();
        int ySize = imageStream.readBinaryShort();
        int dataSize = xSize * ySize;
        byte[] imageBuffer = new byte[dataSize];
        int i = 0;
        while (i < dataSize) {
            imageBuffer[i] = (byte)imageStream.readBinaryByte();
            ++i;
        }
        return this.lcdWriteImage(dest, mode, xPos, yPos, xSize, ySize, imageBuffer);
    }

    public boolean lcdWriteString(int dest, int mode, int xpos, int ypos, String text, CharacterMap typeFace) {
        BitmapCharacter ch;
        int stringWidth = 0;
        short stringHeight = 0;
        byte[] byteText = text.getBytes();
        int i = 0;
        while (i < byteText.length) {
            ch = typeFace.lookupCharacter((short)(byteText[i] & 0xFF));
            stringWidth += ch.getXSize();
            if (ch.getYSize() > stringHeight) {
                stringHeight = ch.getYSize();
            }
            ++i;
        }
        byte[] imageData = new byte[stringWidth * stringHeight];
        int xBase = 0;
        i = 0;
        while (i < byteText.length) {
            ch = typeFace.lookupCharacter((short)(byteText[i] & 0xFF));
            int[] pixelMap = ch.pixelMap;
            byte[] chData = ch.data;
            int x = 0;
            while (x < ch.getXSize()) {
                int xBitOffset = x % 8;
                int xByteOffset = x / 8;
                int yBase = 0;
                int yImageBase = 0;
                int y = 0;
                while (y < ch.getYSize()) {
                    imageData[yImageBase + xBase + x] = (pixelMap[xBitOffset] & chData[xByteOffset + yBase]) != 0 ? (byte)1 : 0;
                    yImageBase += stringWidth;
                    yBase += ch.lineSize;
                    ++y;
                }
                ++x;
            }
            xBase += ch.getXSize();
            ++i;
        }
        return this.lcdWriteImage(dest, mode, xpos, ypos, stringWidth, stringHeight, imageData);
    }

    public byte lcdCompressGraphics(boolean zComp, int compressionFactor, byte[] bitmapData, int size, int compDataSize) {
        boolean i = false;
        return (byte)(i ? 1 : 0);
    }
}

