/*
 * Decompiled with CFR 0.152.
 */
package queueing.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;

public class PageLayout
implements LayoutManager,
LayoutManager2 {
    public static final String HEADER = "HEADER";
    public static final String FOOTER = "FOOTER";
    public static final String CONTENT = "CONTENT";
    private Component headerComp;
    private Component footerComp;
    private Component viewComp;

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        String skey;
        String string = skey = constraints == null ? null : constraints.toString();
        if (HEADER.equals(skey)) {
            this.headerComp = comp;
        } else if (FOOTER.equals(skey)) {
            this.footerComp = comp;
        } else {
            this.viewComp = comp;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == null) {
            return;
        }
        if (this.headerComp != null && this.headerComp.equals(comp)) {
            this.headerComp = null;
        } else if (this.footerComp != null && this.footerComp.equals(comp)) {
            this.footerComp = null;
        } else if (this.viewComp != null && this.viewComp.equals(comp)) {
            this.viewComp = null;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int w = 0;
            int h = 0;
            Component[] comps = new Component[]{this.headerComp, this.viewComp, this.footerComp};
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (c == null || !c.isVisible()) continue;
                Dimension dim = c.getPreferredSize();
                w = Math.max(w, dim.width);
                h += dim.height;
            }
            Insets margin = parent.getInsets();
            return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
        }
    }

    @Override
    public void invalidateLayout(Container target) {
        this.layoutContainer(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int vh;
            boolean footerVisible;
            int hy;
            int fy;
            Insets margin = parent.getInsets();
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            int x = margin.left;
            int y = margin.top;
            int w = pw - (margin.left + margin.top);
            int h = ph - (margin.top + margin.bottom);
            Rectangle headerRect = new Rectangle(x, y, w, 0);
            if (this.headerComp != null && this.headerComp.isVisible()) {
                Dimension dim = this.headerComp.getPreferredSize();
                this.headerComp.setBounds(x, y, w, dim.height);
                headerRect = new Rectangle(x, y, w, dim.height);
            }
            if ((fy = ph - margin.bottom) < (hy = headerRect.y + headerRect.height)) {
                fy = hy;
            }
            Rectangle footerRect = new Rectangle(x, fy, w, 0);
            boolean bl = footerVisible = this.footerComp != null && this.footerComp.isVisible();
            if (footerVisible) {
                Dimension dim = this.footerComp.getPreferredSize();
                int cy = ph - margin.bottom - dim.height;
                if (cy < hy) {
                    cy = hy;
                }
                footerRect = new Rectangle(x, cy, w, dim.height);
                this.footerComp.setBounds(footerRect.x, footerRect.y, footerRect.width, footerRect.height);
            }
            if ((vh = footerRect.y - hy) < 0) {
                vh = 0;
            }
            if (this.viewComp != null && this.viewComp.isVisible() && vh > 0) {
                this.viewComp.setBounds(x, hy, w, vh);
            }
        }
    }
}

