/*
 * Decompiled with CFR 0.152.
 */
package queueing.model;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AbstractUserQueueHandler {
    private static final Global global = new Global();

    public static void add(String key, AbstractUserQueueHandler handler) {
        global.add(key, handler);
    }

    public static void remove(String key) {
        global.remove(key);
    }

    public static void fireNotify(String action, Object data) {
        global.fireNotify(action, data);
    }

    public abstract void notify(String var1, Object var2);

    private static class ExecTask
    implements Runnable {
        private AbstractUserQueueHandler handler;
        private String action;
        private Object data;

        ExecTask(AbstractUserQueueHandler handler, String action, Object data) {
            this.handler = handler;
            this.action = action;
            this.data = data;
        }

        @Override
        public void run() {
            if (this.handler == null) {
                return;
            }
            try {
                this.handler.notify(this.action, this.data);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static class Global {
        private HashMap<String, AbstractUserQueueHandler> handlers = new HashMap();
        private ExecutorService service = Executors.newSingleThreadExecutor();

        private Global() {
        }

        void add(String key, AbstractUserQueueHandler handler) {
            this.handlers.put(key, handler);
        }

        void remove(String key) {
            this.handlers.remove(key);
        }

        void fireNotify(String action, Object data) {
            AbstractUserQueueHandler[] values = this.handlers.values().toArray(new AbstractUserQueueHandler[0]);
            for (int i = 0; i < values.length; ++i) {
                this.service.submit(new ExecTask(values[i], action, data));
            }
        }
    }
}

