/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

class MainViewLayout
implements LayoutManager,
PropertyChangeListener {
    public static final String EXPLORER_SECTION = "EXPLORER";
    public static final String CONTENT_SECTION = "CONTENT";
    private Provider provider;
    private LayoutManager layout;
    private int dividerSize;
    private int dividerLocation;
    private int locationIndex;
    private Component explorer;
    private Component content;
    private Component divider;
    private Point sourcePoint;
    private Point targetPoint;
    private Rectangle viewRect;
    private HorizontalMouseSupport mouseSupport;

    public MainViewLayout(Provider provider) {
        this.provider = provider;
        this.layout = new HorizontalLayout();
        this.setDividerLocation(100);
        this.setDividerSize(5);
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        this.dividerSize = dividerSize;
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int dividerLocation) {
        this.dividerLocation = dividerLocation;
        this.locationIndex = dividerLocation;
    }

    int getLocationIndex() {
        return this.locationIndex;
    }

    void setLocationIndex(int x) {
        this.locationIndex = x;
    }

    private Component getDivider() {
        if (this.divider == null) {
            JLabel lbl = new JLabel();
            lbl.setName("splitview.divider");
            lbl.setCursor(Cursor.getPredefinedCursor(10));
            this.mouseSupport = new HorizontalMouseSupport();
            this.mouseSupport.setDivider(lbl);
            this.divider = lbl;
        }
        return this.divider;
    }

    public Component getLayoutComponent(String name) {
        if (name == null) {
            return null;
        }
        if (EXPLORER_SECTION.equalsIgnoreCase(name)) {
            return this.explorer;
        }
        if (CONTENT_SECTION.equalsIgnoreCase(name)) {
            return this.content;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (comp == null) {
            return;
        }
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (name == null) {
                name = CONTENT_SECTION;
            }
            if (EXPLORER_SECTION.equalsIgnoreCase(name)) {
                this.explorer = comp;
            } else if (CONTENT_SECTION.equalsIgnoreCase(name)) {
                this.content = comp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == null) {
            return;
        }
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (this.explorer != null && this.explorer.equals(comp)) {
                this.explorer = null;
            } else if (this.content != null && this.content.equals(comp)) {
                this.content = null;
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layout.preferredLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layout.minimumLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layout.layoutContainer(parent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("toggleLeftView".equals(name) && this.mouseSupport != null) {
            this.mouseSupport.toggleLeftView();
        }
    }

    private class HorizontalLayout
    implements LayoutManager {
        MainViewLayout root;

        private HorizontalLayout() {
            this.root = MainViewLayout.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                w += MainViewLayout.this.getDividerSize();
                h += MainViewLayout.this.getDividerSize();
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int rw;
                Component divider = MainViewLayout.this.getDivider();
                parent.remove(divider);
                parent.add(divider);
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                MainViewLayout.this.viewRect = new Rectangle(x, y, w, h);
                if (MainViewLayout.this.locationIndex < 0) {
                    MainViewLayout.this.locationIndex = 0;
                } else if (MainViewLayout.this.locationIndex >= pw - margin.right) {
                    MainViewLayout.this.locationIndex = pw - margin.right - MainViewLayout.this.getDividerSize();
                }
                int divX = MainViewLayout.this.locationIndex;
                if (this.root.explorer == null || !this.root.explorer.isVisible()) {
                    divX = 0;
                } else {
                    Dimension dim = this.root.explorer.getPreferredSize();
                    this.root.explorer.setBounds(x, y, divX, h);
                }
                if (this.root.explorer != null) {
                    divider.setBounds(x += divX, y, MainViewLayout.this.getDividerSize(), h);
                    x += MainViewLayout.this.getDividerSize();
                }
                if ((rw = pw - margin.right - x) < 0) {
                    rw = 0;
                }
                if (this.root.content != null) {
                    this.root.content.setBounds(x, y, rw, h);
                }
            }
        }
    }

    private class HorizontalMouseSupport
    implements MouseListener,
    MouseMotionListener {
        MainViewLayout root;
        Component divider;
        private int prevLocationIndex;

        private HorizontalMouseSupport() {
            this.root = MainViewLayout.this;
        }

        void setDivider(Component divider) {
            this.divider = divider;
            divider.addMouseListener(this);
            divider.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HorizontalMouseSupport.this.toggleLeftView();
                    }
                });
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MainViewLayout.this.sourcePoint = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MainViewLayout.this.targetPoint != null) {
                Rectangle rect = this.divider.getBounds();
                int nx = rect.x + ((MainViewLayout)MainViewLayout.this).targetPoint.x;
                if (nx < 0) {
                    ((MainViewLayout)MainViewLayout.this).targetPoint.x = MainViewLayout.this.locationIndex * -1;
                }
                MainViewLayout.this.locationIndex = nx;
            }
            MainViewLayout.this.sourcePoint = null;
            MainViewLayout.this.targetPoint = null;
            if (MainViewLayout.this.locationIndex > 0 && this.root.explorer != null && !this.root.explorer.isVisible()) {
                this.root.explorer.setVisible(true);
            }
            MainViewLayout.this.provider.revalidate();
            MainViewLayout.this.provider.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MainViewLayout.this.targetPoint = e.getPoint();
            Rectangle divRect = this.divider.getBounds();
            int nx = divRect.x + ((MainViewLayout)MainViewLayout.this).targetPoint.x;
            if (nx < 10) {
                ((MainViewLayout)MainViewLayout.this).targetPoint.x = divRect.x * -1 + 10;
            } else {
                int w = ((MainViewLayout)MainViewLayout.this).viewRect.width - divRect.x;
                int limit = w - MainViewLayout.this.getDividerSize() - 10;
                if (((MainViewLayout)MainViewLayout.this).targetPoint.x > limit) {
                    ((MainViewLayout)MainViewLayout.this).targetPoint.x = limit;
                }
            }
            MainViewLayout.this.provider.paintDividerHandle(MainViewLayout.this.viewRect, divRect, MainViewLayout.this.targetPoint);
        }

        private void toggleLeftView() {
            if (this.root.getLocationIndex() == 0) {
                this.root.setLocationIndex(this.prevLocationIndex);
                if (this.root.explorer != null) {
                    this.root.explorer.setVisible(true);
                }
            } else {
                this.prevLocationIndex = this.root.getLocationIndex();
                this.root.setLocationIndex(0);
                if (this.root.explorer != null) {
                    this.root.explorer.setVisible(false);
                }
            }
            MainViewLayout.this.provider.revalidate();
            MainViewLayout.this.provider.repaint();
        }
    }

    public static interface Provider {
        public void revalidate();

        public void repaint();

        public void paintDividerHandle(Rectangle var1, Rectangle var2, Point var3);
    }
}

