/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.ErrorDialog;
import com.rameses.osiris3.platform.LookAndFeelCustomizer;
import com.rameses.osiris3.platform.ModuleEntry;
import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSPlatformLoader;
import com.rameses.osiris3.platform.UpdateCenter;
import java.util.Map;
import javax.swing.UIManager;

public final class OSBootStrap {
    public static void main(String[] args) throws Exception {
        try {
            String plaf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(plaf);
        }
        catch (Throwable plaf) {
            // empty catch block
        }
        OSBootStrap bootstrap = new OSBootStrap();
        bootstrap.showStartup();
        bootstrap.startUpdates();
    }

    private OSBootStrap() {
    }

    private void showStartup() {
        try {
            OSManager osm = OSManager.getInstance();
            osm.init();
            osm.getStartupWindow().setVisible(true);
        }
        catch (Throwable t) {
            ErrorDialog.show(t);
            this.terminate();
        }
    }

    private void startUpdates() {
        try {
            UpdateCenterHandler handler = new UpdateCenterHandler();
            OSPlatformLoader.DownloadResult result = OSPlatformLoader.downloadUpdates(handler);
            Map env = result.getEnv();
            this.prepareLookAndFeel(env);
            OSManager osm = OSManager.getInstance();
            osm.setAppLoader(result.deriveAppLoader());
            osm.getMainWindow().show();
        }
        catch (Throwable t) {
            ErrorDialog.show(t);
            this.terminate();
        }
    }

    private void prepareLookAndFeel(Map env) {
        try {
            String plaf = (String)env.get("plaf");
            if (plaf != null && plaf.trim().length() > 0) {
                UIManager.setLookAndFeel(plaf);
            } else if (System.getProperty("os.name", "").toLowerCase().indexOf("windows") >= 0) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LookAndFeelCustomizer.install();
    }

    private void terminate() {
        try {
            System.exit(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class UpdateCenterHandler
    implements UpdateCenter.Handler {
        private UpdateCenterHandler() {
        }

        @Override
        public void onmessage(String message) {
            OSManager.getInstance().getStartupWindow().setTextValue(message);
        }

        @Override
        public void ondownload(ModuleEntry me) {
            String msg = "Downloading " + me.getFilename() + "...";
            this.onmessage(msg);
        }

        @Override
        public void oncomplete() {
            this.onmessage("Initializing please wait...");
        }
    }
}

