/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class OSGlassPane
extends JPanel {
    public OSGlassPane() {
        this.initComponent();
    }

    private void initComponent() {
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                e.consume();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clip = g.getClipBounds();
        AlphaComposite alpha = AlphaComposite.SrcOver.derive(0.85f);
        Composite oldComposite = g2.getComposite();
        g2.setComposite(alpha);
        g2.setColor(this.getBackground());
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.setComposite(oldComposite);
    }

    @Override
    public void setVisible(boolean visible) {
        this.setFocusable(visible);
        super.setVisible(visible);
        if (visible) {
            this.requestFocusInWindow();
            Component comp = this.getContent();
            if (!(comp instanceof JInternalFrame)) {
                this.transferFocus();
            }
            if (comp instanceof Container) {
                Container con = (Container)comp;
                con.setFocusCycleRoot(true);
            } else {
                this.setFocusCycleRoot(true);
            }
        }
    }

    public Component getContent() {
        Component[] comps = this.getComponents();
        if (comps.length > 0) {
            return comps[0];
        }
        return null;
    }

    private class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component comp = this.getFirstVisible(parent);
                if (comp != null) {
                    Dimension dim = comp.getPreferredSize();
                    w = dim.width;
                    h = dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        private Component getFirstVisible(Container parent) {
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                return comps[i];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component comp = this.getFirstVisible(parent);
                if (comp != null) {
                    Dimension dim = comp.getPreferredSize();
                    if (dim.width < pw) {
                        x = (w - dim.width) / 2 + margin.left;
                    }
                    if (dim.height < ph) {
                        y = (h - dim.height) / 2 + margin.top;
                    }
                    x = Math.max(x, margin.left);
                    y = Math.max(y, margin.top);
                    comp.setBounds(x, y, dim.width, dim.height);
                }
            }
        }
    }
}

