/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.GlassPaneImpl;
import com.rameses.osiris3.platform.MainViewPanel;
import com.rameses.osiris3.platform.MainWindowPanel;
import com.rameses.osiris3.platform.OSMainTabbedPane;
import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSPlatformIdentity;
import com.rameses.osiris3.platform.OSTabbedView;
import com.rameses.platform.interfaces.MainWindow;
import com.rameses.platform.interfaces.MainWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

class OSMainWindow
implements MainWindow {
    private MainWindowListener mainWindowListener;
    private JFrame window;
    private JPanel plainContentPanel;
    private MainWindowPanel mainWindowPanel;
    private MainViewPanel mainViewPanel;
    private OSMainTabbedPane tabbedPane;
    private GlassPaneImpl glassPane;
    private DefaultGlassPane defaultGlassPane;

    public OSMainWindow() {
        this.initComponent();
        this.initComponents();
    }

    private void initComponent() {
        OSPlatformIdentity spi = OSPlatformIdentity.getInstance();
        ImageIcon icon = spi.getIcon("icon");
        this.window = new JFrame();
        this.window.setTitle("Rameses Client Platform");
        this.window.setDefaultCloseOperation(0);
        this.glassPane = new GlassPaneImpl(this);
        this.window.setGlassPane(this.glassPane);
        this.defaultGlassPane = new DefaultGlassPane();
        Image image = null;
        try {
            image = icon.getImage();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (image == null) {
                image = spi.getDefaultIcon().getImage();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (image != null) {
                this.window.setIconImage(image);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OSMainWindow.this.windowClosingImpl(e);
            }
        });
    }

    private void initComponents() {
        this.plainContentPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new OSMainTabbedPane();
        this.mainViewPanel = new MainViewPanel();
        this.mainViewPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 2, 3));
        this.mainViewPanel.setContent(this.tabbedPane);
        this.mainWindowPanel = new MainWindowPanel();
        this.mainWindowPanel.setContent(this.mainViewPanel);
        this.window.setContentPane(this.mainWindowPanel);
    }

    public final JFrame getComponent() {
        return this.window;
    }

    public final JRootPane getRootPane() {
        return this.window.getRootPane();
    }

    void setContent(Container content) {
        this.plainContentPanel.removeAll();
        if (content != null) {
            this.plainContentPanel.add(content);
            this.window.setContentPane(this.plainContentPanel);
        }
        this.plainContentPanel.revalidate();
        this.plainContentPanel.repaint();
    }

    Component findExplorer(String id) {
        if (id == null) {
            return null;
        }
        Component comp = this.mainViewPanel.getExplorer();
        if (comp != null && id.equals(comp.getName())) {
            return comp;
        }
        return null;
    }

    void reinitialize() {
        this.mainViewPanel.removeAll();
        this.plainContentPanel.removeAll();
        this.initComponents();
    }

    @Override
    public void setListener(MainWindowListener mainWindowListener) {
        this.mainWindowListener = mainWindowListener;
    }

    @Override
    public void setTitle(String title) {
        StringBuffer sb = new StringBuffer();
        if (title == null || title.length() == 0) {
            sb.append("Rameses Client Platform");
        } else {
            sb.append(title);
        }
        OSPlatformIdentity spi = OSPlatformIdentity.getInstance();
        String platformtype = spi.getString("platform.type");
        if ("enterpise".equals(platformtype)) {
            sb.append("  Enterprise Edition");
        } else if ("community".equals(platformtype)) {
            sb.append("  Community Edition");
        }
        this.window.setTitle(sb.toString());
    }

    @Override
    public void close() {
        try {
            if (this.mainWindowListener != null && !this.mainWindowListener.onClose()) {
                return;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.window.dispose();
        try {
            System.exit(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void show() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OSMainWindow.this.showImpl();
            }
        });
    }

    @Override
    public void setComponent(JComponent comp, String constraint) {
        if (comp == null || constraint == null) {
            return;
        }
        if ("menubar".equals(constraint)) {
            this.mainWindowPanel.setMenuBar((JMenuBar)comp);
        } else if ("toolbar".equals(constraint)) {
            if (comp instanceof JToolBar) {
                ((JToolBar)comp).setFloatable(false);
            }
            if (comp != null) {
                comp.setBorder(new ToolbarBorder());
            }
            this.mainWindowPanel.setToolBar(comp);
        } else if ("statusbar".equals(constraint)) {
            comp.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.mainWindowPanel.setStatusBar(comp);
        } else if ("content".equals(constraint)) {
            this.tabbedPane.add(comp);
        } else if ("explorer".equals(constraint)) {
            String title = " ";
            if (comp instanceof OSTabbedView) {
                title = ((OSTabbedView)comp).getTitle();
            }
            this.mainViewPanel.setExplorer(comp, title);
            this.mainViewPanel.updateCanvas();
        } else {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.updateComponentTreeUI(OSMainWindow.this.mainWindowPanel);
            }
        });
    }

    private void showImpl() {
        Object oval = this.window.getRootPane().getClientProperty("Window.showInit");
        if (oval == null) {
            Dimension scrdim = Toolkit.getDefaultToolkit().getScreenSize();
            Insets margin = Toolkit.getDefaultToolkit().getScreenInsets(this.window.getGraphicsConfiguration());
            scrdim.width -= margin.left + margin.right + 80;
            scrdim.height -= margin.top + margin.bottom + 40;
            this.window.setSize(scrdim.width, scrdim.height);
            this.window.setLocation(40, 20);
            KeyStroke ks = KeyStroke.getKeyStroke("ctrl shift I");
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSMainWindow.this.showInfo(e);
                }
            };
            JRootPane rootPane = this.window.getRootPane();
            rootPane.registerKeyboardAction(al, ks, 2);
            this.window.getRootPane().putClientProperty("Window.showInit", true);
        }
        this.window.setVisible(true);
        OSManager.getInstance().closeStartupWindow();
    }

    private void showInfo(ActionEvent e) {
        if (this.mainViewPanel.isExplorerInFocus()) {
            this.mainViewPanel.showExplorerInfo();
        } else {
            this.tabbedPane.showInfo();
        }
    }

    private void windowClosingImpl(WindowEvent e) {
        this.close();
    }

    void restoreMainPanel() {
        if (this.mainWindowPanel == null) {
            return;
        }
        Container con = this.window.getContentPane();
        if (this.mainWindowPanel.equals(con)) {
            return;
        }
        this.window.setContentPane(this.mainWindowPanel);
        this.mainWindowPanel.revalidate();
        this.mainWindowPanel.repaint();
    }

    void hideGlassPane() {
        this.glassPane.setVisible(false);
        this.glassPane.removeAll();
        this.defaultGlassPane.setVisible(false);
        this.defaultGlassPane.removeAll();
    }

    void showInGlassPane(Component comp, Map props) {
        if (props == null) {
            props = new HashMap();
        }
        if (comp instanceof ViewContext) {
            this.glassPane.removeAll();
            this.glassPane.add(comp);
            String id = (String)props.get("id");
            this.glassPane.setName(id);
            this.showGlassPaneImpl(this.glassPane);
            OSManager.getInstance().registerView(id, this.glassPane);
        } else {
            this.defaultGlassPane.removeAll();
            this.defaultGlassPane.add(comp);
            this.showGlassPaneImpl(this.defaultGlassPane);
        }
    }

    private void showGlassPaneImpl(JComponent jcomp) {
        this.window.setGlassPane(jcomp);
        jcomp.setVisible(true);
        SwingUtilities.updateComponentTreeUI(jcomp);
    }

    void requestFocus() {
        if (this.tabbedPane != null) {
            Component comp = this.tabbedPane.getSelectedComponent();
            if (comp != null) {
                this.tabbedPane.setFocusable(true);
                this.tabbedPane.requestFocus();
                this.tabbedPane.transferFocus();
            }
        } else {
            this.window.requestFocus();
            this.window.transferFocus();
        }
    }

    private class DefaultGlassPane
    extends JPanel {
        DefaultGlassPane() {
            this.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    e.consume();
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    e.consume();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    e.consume();
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
        }
    }

    private class StatusbarBorder
    extends AbstractBorder {
        private StatusbarBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics g2 = g.create();
            g2.setColor(UIManager.getColor("controlShadow"));
            g2.drawLine(x, y, width - 1, y);
            g2.setColor(UIManager.getColor("controlHighlight"));
            g2.drawLine(x, y + 1, width - 1, y + 1);
            g2.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(4, 1, 1, 1);
        }
    }

    private class ToolbarBorder
    extends AbstractBorder {
        private ToolbarBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics g2 = g.create();
            g2.setColor(UIManager.getColor("controlShadow"));
            g2.drawLine(x, height - 1, width - 1, height - 1);
            g2.setColor(UIManager.getColor("controlHighlight"));
            g2.drawLine(x, height - 2, width - 1, height - 2);
            g2.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 4, 1);
        }
    }
}

