/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.DownloadPanel;
import com.rameses.osiris3.platform.ErrorDialog;
import com.rameses.osiris3.platform.OSAppLoader;
import com.rameses.osiris3.platform.OSMainWindow;
import com.rameses.osiris3.platform.OSPlatform;
import com.rameses.osiris3.platform.OSScreenLock;
import com.rameses.osiris3.platform.OSStartupWindow;
import com.rameses.osiris3.platform.OSView;
import com.rameses.osiris3.platform.WaitPanel;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JMenuBar;

final class OSManager {
    private static ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
    private static OSManager instance;
    static final Object VIEW_LOCK;
    private Object treeLock = new Object();
    private OSMainWindow osMainWindow;
    private OSPlatform osPlatform;
    private JMenuBar menubar;
    private Container toolbarView;
    private Container desktopView;
    private Container statusView;
    private Map<Object, Object> properties = new Hashtable<Object, Object>();
    private Map<String, OSView> views = new LinkedHashMap<String, OSView>();
    private OSStartupWindow startupWindow;
    private OSAppLoader osAppLoader;
    private OSScreenLock osScreenLock;
    private Scheduler scheduler;

    public static ClassLoader getOriginalClassLoader() {
        return originalClassLoader;
    }

    public static OSManager getInstance() {
        if (instance == null) {
            instance = new OSManager();
        }
        return instance;
    }

    private OSManager() {
    }

    void init() {
        this.osMainWindow = new OSMainWindow();
        this.osPlatform = new OSPlatform(this);
    }

    OSMainWindow getMainWindow() {
        return this.osMainWindow;
    }

    OSPlatform getPlatform() {
        return this.osPlatform;
    }

    void reinitialize() {
        this.osMainWindow.reinitialize();
        this.osPlatform = new OSPlatform(this);
        if (this.osAppLoader == null) {
            this.osMainWindow.setContent(new JLabel(""));
        } else {
            WaitPanel wp = WaitPanel.create("Loading please wait...");
            this.osMainWindow.showInGlassPane(wp, null);
            this.osAppLoader.load(this.osPlatform);
        }
        this.osMainWindow.hideGlassPane();
    }

    void startUpdate() {
        this.startUpdateImpl(false);
    }

    void retryUpdate() {
        this.startUpdateImpl(true);
    }

    private void startUpdateImpl(final boolean retry) {
        DownloadPanel pnl = null;
        try {
            pnl = new DownloadPanel();
            this.osMainWindow.setContent(pnl);
            this.osMainWindow.show();
        }
        catch (Throwable t) {
            ErrorDialog.show(t);
            t.printStackTrace();
        }
        final DownloadPanel dpnl = pnl;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (retry) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                dpnl.startDownload();
            }
        };
        new Thread(runnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerView(String id, OSView view) {
        Object object = VIEW_LOCK;
        synchronized (object) {
            if (id == null || id.trim().length() == 0 || view == null) {
                return false;
            }
            if (this.views.containsKey(id)) {
                return false;
            }
            this.views.put(id, view);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OSView unregisterView(String id) {
        Object object = VIEW_LOCK;
        synchronized (object) {
            if (id == null || id.trim().length() == 0) {
                return null;
            }
            return this.views.remove(id);
        }
    }

    OSView lookupView(String id) {
        if (id == null) {
            return null;
        }
        return this.views.get(id);
    }

    boolean containsView(String id) {
        return this.lookupView(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterAllViews() {
        Object object = VIEW_LOCK;
        synchronized (object) {
            this.views.clear();
        }
    }

    List<OSView> findViews(String type) {
        ArrayList<OSView> list = new ArrayList<OSView>();
        if (type == null) {
            return list;
        }
        for (OSView vw : this.views.values()) {
            if (!type.equals(vw.getType())) continue;
            list.add(vw);
        }
        return list;
    }

    Iterator<OSView> findAll() {
        return this.views.values().iterator();
    }

    OSStartupWindow getStartupWindow() {
        if (this.startupWindow == null) {
            this.startupWindow = new OSStartupWindow();
        }
        return this.startupWindow;
    }

    void closeStartupWindow() {
        if (this.startupWindow == null) {
            return;
        }
        this.startupWindow.dispose();
        this.startupWindow = null;
    }

    OSAppLoader getAppLoader() {
        return this.osAppLoader;
    }

    void setAppLoader(OSAppLoader osAppLoader) {
        OSAppLoader old = this.osAppLoader;
        if (old != null) {
            old.destroy();
        }
        this.osAppLoader = osAppLoader;
        if (osAppLoader != null) {
            osAppLoader.load(this.osPlatform);
        }
    }

    OSScreenLock getScreenLock() {
        return this.osScreenLock;
    }

    void setScreenLock(OSScreenLock osScreenLock) {
        OSScreenLock old = this.osScreenLock;
        if (old != null) {
            this.unregisterView(old.getName());
        }
        this.osScreenLock = osScreenLock;
    }

    void scheduleTask(Runnable runnable, long delay) {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
        }
        this.scheduler.addTask(runnable, delay);
    }

    void stopScheduledTasks() {
        if (this.scheduler != null) {
            this.scheduler.stopAllTasks();
        }
    }

    static {
        VIEW_LOCK = new OSViewLock();
    }

    private class ScheduledTask
    extends TimerTask {
        private Runnable target;

        ScheduledTask(Runnable target) {
            this.target = target;
        }

        @Override
        public void run() {
            if (this.target != null) {
                this.target.run();
            }
        }
    }

    private class Scheduler {
        private Timer timer = new Timer();
        private boolean enabled = true;

        Scheduler() {
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        void addTask(Runnable runnable, long delay) {
            if (!this.enabled) {
                return;
            }
            ScheduledTask task = new ScheduledTask(runnable);
            this.timer.schedule((TimerTask)task, delay);
        }

        void stopAllTasks() {
            try {
                this.timer.cancel();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.timer.purge();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.timer = new Timer();
        }
    }

    static class OSViewLock {
        OSViewLock() {
        }
    }
}

