/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.common.PropertyResolver;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerFilter;
import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.common.ExplorerViewListController;
import com.rameses.osiris2.common.ExplorerViewService;
import com.rameses.rcp.annotations.Controller;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.TreeNodeModel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.util.ControlSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExplorerViewController {
    @com.rameses.rcp.annotations.Invoker
    protected Invoker invoker;
    @com.rameses.rcp.annotations.Binding
    protected Binding binding;
    @Controller(onready="setupWorkunitProperties")
    protected Object controller;
    private String context;
    private String defaultFileType;
    private String serviceName;
    private TreeNodeModel nodeModel;
    private Node selectedNode;
    private ExplorerViewService service;
    private Object serviceObject;
    private Map wuprops;
    private String wucontext;
    private String wudefaultFileType;
    private String wuserviceName;
    private boolean wuallowSearch;
    private boolean wurootVisible;
    private boolean wuautoSelect;
    private boolean wuallowCreate;
    private boolean wuallowOpen;
    private boolean _showQueryForm;
    private String _queryFormName;
    private Opener _queryform;
    private ExplorerViewListController listHandler;

    public void init() {
    }

    public String getTitle() {
        return this.invoker == null ? null : this.invoker.getCaption();
    }

    public String getContext() {
        return this.wucontext;
    }

    public String getDefaultFileType() {
        return this.wudefaultFileType;
    }

    public String getServiceName() {
        return this.wuserviceName;
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Node selectedNode) {
        this.selectedNode = selectedNode;
    }

    public TreeNodeModel getNodeModel() {
        if (this.nodeModel == null) {
            this.nodeModel = new TreeNodeModelImpl();
        }
        return this.nodeModel;
    }

    public ExplorerViewService getService() {
        if (this.service == null) {
            String name = this.getServiceName();
            if (name == null || name.trim().length() == 0) {
                throw new IllegalStateException("Please specify a serviceName");
            }
            this.service = (ExplorerViewService)InvokerProxy.getInstance().create(name, ExplorerViewService.class);
        }
        return this.service;
    }

    public String getIcon() {
        return null;
    }

    public boolean isRootVisible() {
        return this.wurootVisible;
    }

    public boolean isAllowSearch() {
        return this.wuallowSearch;
    }

    public boolean isAutoSelect() {
        return this.wuautoSelect;
    }

    public boolean isAllowCreate() {
        return this.wuallowCreate;
    }

    public boolean isAllowOpen() {
        return this.wuallowOpen;
    }

    protected void beforeNodes(Map params) {
    }

    protected List<Map> getNodes(Map params) {
        this.beforeNodes(params);
        Map map = this.getWorkunitProperties();
        if (map != null && map.containsKey("tag")) {
            params.put("_tag", map.get("tag"));
        }
        return this.getService().getNodes(params);
    }

    protected final Map getWorkunitProperties() {
        if (this.wuprops == null) {
            try {
                PropertyResolver resolver = PropertyResolver.getInstance();
                this.wuprops = (Map)resolver.getProperty(this.controller, "workunit.workunit.properties");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.wuprops == null) {
                this.wuprops = new HashMap();
            }
        }
        return this.wuprops;
    }

    public final List<Action> lookupActions(String type) {
        List<Action> actions = new ArrayList();
        try {
            actions = InvokerUtil.lookupActions((String)type, (InvokerFilter)new InvokerFilter(){

                public boolean accept(Invoker o) {
                    return o.getWorkunitid().equals(ExplorerViewController.this.invoker.getWorkunitid());
                }
            });
        }
        catch (Throwable t) {
            System.out.println("[WARN] error lookup actions caused by " + t.getMessage());
        }
        for (int i = 0; i < actions.size(); ++i) {
            Action newAction = actions.get(i).clone();
            actions.set(i, newAction);
        }
        return actions;
    }

    private boolean containsPage(String name) {
        try {
            PropertyResolver resolver = PropertyResolver.getInstance();
            Map pages = (Map)resolver.getProperty(this.controller, "workunit.workunit.pages");
            return pages.containsKey(name);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void setupWorkunitProperties() {
        Map map = this.getWorkunitProperties();
        this.wucontext = this.getString(map, "context");
        if (this.wucontext == null) {
            this.wucontext = "explorer";
        }
        this.wudefaultFileType = this.getString(map, "defaultFileType");
        this.wuserviceName = this.getString(map, "serviceName");
        String sval = this.getString(map, "allowSearch");
        this.wuallowSearch = !"false".equals(sval);
        this.wurootVisible = "true".equals(this.getString(map, "rootVisible"));
        this.wuautoSelect = !"false".equals(this.getString(map, "autoSelect"));
        this.wuallowCreate = !"false".equals(this.getString(map, "allowCreate"));
        this.wuallowOpen = !"false".equals(this.getString(map, "allowOpen"));
    }

    private String getString(Map map, String name) {
        if (map == null || name == null) {
            return null;
        }
        Object ov = map == null ? null : (Object)map.get(name);
        return ov == null ? null : ov.toString();
    }

    public Binding getBinding() {
        Object ob;
        Object object = ob = this.nodeModel == null ? null : this.nodeModel.getBinding();
        if (ob instanceof Binding) {
            return (Binding)ob;
        }
        return null;
    }

    public ExplorerViewListController getListHandler() {
        if (this.listHandler == null) {
            this.listHandler = new ExplorerViewListController();
            this.listHandler.setParent(this);
        }
        return this.listHandler;
    }

    public boolean isQueryFormVisible() {
        return this._showQueryForm;
    }

    public Opener getQueryForm() {
        Object value;
        Object o;
        if (!this.isAllowSearch() && (o = this.getNode()) instanceof Map && !"true".equals((value = ((Map)o).get("allowSearch")) + "")) {
            return null;
        }
        if (this.isQueryFormVisible()) {
            o = new Opener();
            o.setOutcome(this._queryFormName);
            return o;
        }
        return null;
    }

    public Map getQuery() {
        return this.getListHandler().getQuery();
    }

    public void search() {
        this.getListHandler().search();
    }

    public Object getNode() {
        Node node = this.getListHandler().getNode();
        return node == null ? null : node.getItem();
    }

    public Object getSelectedEntity() {
        return this.listHandler == null ? null : this.listHandler.getSelectedEntity();
    }

    public void beforeFetchList(Map params) {
    }

    public Object openItem(Map item) {
        return null;
    }

    public Map getInfo() {
        return this.getWorkunitProperties();
    }

    private class TreeNodeModelImpl
    extends TreeNodeModel {
        ExplorerViewController root;

        private TreeNodeModelImpl() {
            this.root = ExplorerViewController.this;
        }

        public boolean isRootVisible() {
            return this.root.isRootVisible();
        }

        public boolean isAutoSelect() {
            return this.root.isAutoSelect();
        }

        public String getIcon() {
            String icon = this.root.getIcon();
            if (icon == null || icon.length() == 0) {
                return "Tree.closedIcon";
            }
            return icon;
        }

        public List<Map> getNodeList(Node node) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Object item = node.getItem();
            if (item instanceof Map) {
                params.putAll((Map)item);
            } else {
                params.put("item", node.getItem());
            }
            params.put("root", node.getParent() == null);
            params.put("caption", node.getCaption());
            List<Map> nodes = this.root.getNodes(params);
            if (nodes == null) {
                nodes = new ArrayList<Map>();
            }
            if (node.getParent() == null && this.root.isAllowSearch()) {
                HashMap<String, Object> search = new HashMap<String, Object>();
                search.put("folder", false);
                search.put("name", "search");
                search.put("caption", "Search");
                search.put("icon", "images/doc-view16.png");
                if (nodes.isEmpty()) {
                    nodes.add(search);
                } else {
                    nodes.add(0, search);
                }
            }
            return nodes;
        }

        public void initChildNodes(Node[] nodes) {
            if (nodes == null) {
                return;
            }
            for (Node node : nodes) {
                if (node.getIcon() != null) continue;
                String icon = node.getPropertyString("filetype");
                if (icon == null) {
                    icon = "default_folder";
                }
                String path = "images/explorer/" + this.root.getContext();
                node.getProperties().put("iconpath", path);
                String res = path + "/" + icon.toLowerCase() + ".png";
                if (ControlSupport.isResourceExist((String)res)) {
                    node.setIcon(res);
                    continue;
                }
                node.setIcon(this.getIcon());
            }
        }

        public Object openFolder(Node node) {
            return this.openNodeImpl(node);
        }

        public Object openLeaf(Node node) {
            return this.openNodeImpl(node);
        }

        private Object openNodeImpl(Node node) {
            String nodeName;
            if (node == null) {
                return null;
            }
            String filetype = node.getPropertyString("filetype");
            if (filetype == null) {
                String[] values;
                String childtypes = node.getPropertyString("childtypes");
                String[] stringArray = values = childtypes == null ? null : childtypes.split(",");
                if (values != null && values.length > 0) {
                    filetype = values[0];
                }
            }
            if (filetype == null) {
                filetype = ExplorerViewController.this.getDefaultFileType();
            }
            ExplorerViewController.this._queryFormName = "queryform";
            String string = nodeName = node == null ? null : node.getPropertyString("name");
            if ("search".equals(nodeName + "")) {
                ExplorerViewController.this._showQueryForm = true;
            } else {
                String sfiletype;
                String sallowSearch = node == null ? null : node.getPropertyString("allowSearch");
                String string2 = sfiletype = node == null ? null : node.getPropertyString("filetype");
                if (sfiletype != null) {
                    sfiletype = sfiletype.toLowerCase();
                }
                ExplorerViewController.this._showQueryForm = "true".equals(sallowSearch);
                if (ExplorerViewController.this._showQueryForm && ExplorerViewController.this.containsPage(sfiletype + ":queryform")) {
                    ExplorerViewController.this._queryFormName = sfiletype + ":queryform";
                }
            }
            ExplorerViewController.this.getListHandler().setNode(node);
            ExplorerViewController.this.getListHandler().setExtendedProperties(ExplorerViewController.this.getWorkunitProperties());
            ExplorerViewController.this.getListHandler().updateView();
            Object ob = this.getBinding();
            if (ob instanceof Binding) {
                Binding ab = (Binding)ob;
                ab.refresh("nodechange");
                ab.refresh("listHandler.*");
            }
            return null;
        }
    }
}

