/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.common;

import com.rameses.common.ExpressionResolver;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.client.InvokerProxy;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.common.ExplorerNodeViewer;
import com.rameses.osiris2.common.ExplorerViewerService;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.TreeNodeModel;
import com.rameses.rcp.framework.Binding;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExplorerViewerController {
    @com.rameses.rcp.annotations.Invoker
    protected Invoker invoker;
    @com.rameses.rcp.annotations.Binding
    protected Binding binding;
    private Opener openerObject;
    private ExplorerViewerService service;
    private String scheme = "explorer";
    private String serviceName;
    private Node selectedNode;
    private Map<String, Opener> openers = new HashMap<String, Opener>();
    private TreeNodeModel nodeModel;

    public Object getNodeModel() {
        return this.getTreeNodeModel();
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Node selectedNode) {
        this.selectedNode = selectedNode;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getScheme() {
        return this.scheme;
    }

    public ExplorerViewerService getService() {
        String name = this.getServiceName();
        if (name == null || name.trim().length() == 0) {
            throw new RuntimeException("No service name specified");
        }
        if (this.service == null) {
            this.service = (ExplorerViewerService)InvokerProxy.getInstance().create(name, ExplorerViewerService.class);
        }
        return this.service;
    }

    public Opener getOpenerObject() {
        return this.openerObject;
    }

    private final TreeNodeModel getTreeNodeModel() {
        if (this.nodeModel == null) {
            this.nodeModel = new TreeNodeModelImpl();
        }
        return this.nodeModel;
    }

    private class TreeNodeModelImpl
    extends TreeNodeModel {
        ExplorerViewerController root;

        private TreeNodeModelImpl() {
            this.root = ExplorerViewerController.this;
        }

        public boolean isRootVisible() {
            return false;
        }

        public String getIcon() {
            return "Tree.closedIcon";
        }

        public List<Map> getNodeList(Node node) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Object item = node.getItem();
            if (item instanceof Map) {
                params.putAll((Map)item);
            } else {
                params.put("item", node.getItem());
            }
            params.put("root", node.getParent() == null);
            params.put("caption", node.getCaption());
            List<Map> nodes = ExplorerViewerController.this.getService().getNodes(params);
            if (node.getParent() == null) {
                HashMap<String, Object> search = new HashMap<String, Object>();
                search.put("name", "search");
                search.put("caption", "Search");
                search.put("type", "search");
                search.put("icon", "images/doc-view16.png");
                search.put("leaf", true);
                if (nodes.isEmpty()) {
                    nodes.add(search);
                } else {
                    nodes.add(0, search);
                }
            }
            return nodes;
        }

        public void initChildNodes(Node[] nodes) {
            if (nodes == null) {
                return;
            }
            for (Node node : nodes) {
                String nodeClass = node.getPropertyString("nodeclass");
                if (nodeClass == null || nodeClass.length() == 0) continue;
                try {
                    List actions = InvokerUtil.lookupActions((String)(ExplorerViewerController.this.getScheme() + ":" + nodeClass));
                    if (actions == null || actions.isEmpty()) continue;
                    Action a = (Action)actions.remove(0);
                    actions.clear();
                    if (a.getIcon() == null || a.getIcon().length() <= 0) continue;
                    node.setIcon(a.getIcon());
                }
                catch (Throwable t) {
                    System.out.println("[WARN] error init child nodes caused by " + t.getMessage());
                }
            }
        }

        public Object openFolder(Node node) {
            return this.openNodeImpl(node);
        }

        public Object openLeaf(Node node) {
            return this.openNodeImpl(node);
        }

        private Object openNodeImpl(Node node) {
            if (node == null) {
                return null;
            }
            Opener opener = (Opener)ExplorerViewerController.this.openers.get(node.getId());
            if (opener == null) {
                String invokerType = this.root.getScheme() + ":node";
                try {
                    List list = InvokerUtil.lookupOpeners((String)invokerType);
                    if (list != null) {
                        ExpressionResolver resolver = ExpressionResolver.getInstance();
                        while (!list.isEmpty()) {
                            Opener o = (Opener)list.remove(0);
                            String expr = (String)o.getProperties().get("expr");
                            if (expr == null || expr.length() == 0) {
                                opener = o;
                                break;
                            }
                            try {
                                if (!resolver.evalBoolean(expr, node.getItem())) continue;
                                opener = o;
                                break;
                            }
                            catch (Throwable t) {
                                System.out.println("[WARN] " + t.getMessage());
                            }
                        }
                        list.clear();
                    }
                }
                catch (Throwable t) {
                    System.out.println("[WARN] error caused by " + t.getMessage());
                }
                if (opener == null) {
                    opener = InvokerUtil.lookupOpener((String)"explorer-default-viewer", new HashMap());
                }
                ExplorerViewerController.this.openers.put(node.getId(), opener);
            }
            ExplorerNodeViewer viewer = (ExplorerNodeViewer)opener.getHandle();
            viewer.setNode(node);
            viewer.updateView();
            ExplorerViewerController.this.openerObject = opener;
            if (ExplorerViewerController.this.binding != null) {
                ExplorerViewerController.this.binding.refresh("subform");
            }
            return null;
        }
    }
}

