package com.rameses.gov.treasury.tool.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.BreakException;

class DishonorCheckPaymentModel {

    @Service('DishonoredCheckPaymentService') 
    def svc;
    
    @Binding 
    def binding;
    
    def mode; 
    def remarks;
    def filter = [:]; 
    
    void init() {
        mode = 'init'; 
        remarks = null; 
        filter = [
            depositvoucher: [:],
            checkpayment: [:]
        ]; 
    }
    
    def getTitle() {
        def buff = new StringBuilder(); 
        buff.append("Dishonored Check Payment"); 
        if ( mode == 'init') buff.append(": Initial"); 
        else if ( mode == 'finish') buff.append(": Finished"); 
        return buff.toString(); 
    }
    
    
    def doCancel() {
        if ( mode == 'finish') return '_close'; 
        
        if ( MsgBox.confirm('You are about to close this window. Continue?')) {
            return '_close'; 
        }
        return null; 
    }

    def doSearch() {
        def res = svc.search( filter ); 
        return null; 
    }
    
    def doNew() {
        init(); 
        return 'default'; 
    }
}