package com.rameses.jasper.models;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import com.rameses.email.*;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.rcp.framework.*;


public class SysMessageTemplateModel extends CrudFormModel {
    

    public String getConnection() {
        return caller.getConnection();
    }
    
    public def getDataSvc() {
        return InvokerProxy.instance.create("SysReportDataService", null, connection );
    }

    public def getTemplateSvc() {
        return InvokerProxy.instance.create("SysMessageTemplateService", null, connection );
    }

    def viewData() {
        def data = dataSvc.getData( [statement: entity.statement, params: [:] ] );
        if( data instanceof List ) {
            data = [ list: data ];
        }
        Modal.show("debug:view", [schema:[], data:data]);   
    }

    def testTemplate() {
    	def test = templateSvc.getRender( [ templateid: entity.objid, params: [:] ] );
    	return Inv.lookupOpener("sys_message_queue:test", [entity: test ]);  	
    }

    
}