package com.rameses.jasper.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.util.*;
import com.rameses.common.*;
import com.rameses.rcp.constant.*;
import com.rameses.osiris2.reports.*;
import net.sf.jasperreports.engine.*;
import com.rameses.rcp.framework.ClientContext;

class SysReportFormModel extends ReportModel  {

    @Binding
    def binding;
    
    def reportid;
    def reportDef;
    def reportInfo;
    String connection;
    def reportOutput;
    def mode;

    def paramControls = [];
    def filterFields;
    
    boolean allowPrint = true;

    public boolean isAllowSave() { 
        return true;
    }
    
    public def getReportService() {
        return InvokerProxy.instance.create("SysReportService", null, connection );
    }
    
    public def getReportTemplateService() {
        return InvokerProxy.instance.create("SysReportTemplateService", null, connection );
    }    
    
    public String getReportName() {
        return reportInfo.filepath;
    }
    
    final def getModel() { 
        return reportOutput;
    }

    def query = [:];
    def filters = [];
    
    @FormTitle
    public String getTitle() {
        return reportDef.title;
    }
    
    public Object getReportData() {
        return getReportService().getReportData([ name: reportDef.name, params:query, filters: filters ]);
    }
    
    public Map getParameters() {
        return [:];
    }

    boolean loadReport() throws Exception  {
        def data = getReportData(); 
        if ( !data ) return false;

        afterReportData( data );
        //load the template
        def tmp = reportDef.template;
        if( tmp ) {
            if( tmp.trim().contains("#{") ) {
                try {
                    tmp = ExpressionResolver.getInstance().evalString(tmp, query);    
                }
                catch(ex) {
                    ex.printStackTrace();
                }
            } 
        }
        else if( data instanceof List ) {
            if(data.size() >0) {
                def d1 = data[0];
                if(d1 instanceof Map ) tmp = d1.template; 
            }            
        }
        else if( data instanceof Map ) {
            tmp = data.template;
        }
        if(!tmp) throw new Exception("Please provide a template or return a template value in the data");
        reportInfo = reportTemplateService.getInfo( [name: tmp ] );
        if(!reportInfo) throw new Exception("report template " + tmp + " not found");            

        //this needs report name
        Map conf = new HashMap();
        loadReportParams( conf );
        afterLoadReportParams( conf );

        def handler = [
            getResources: { id->
                return reportTemplateService.getResources([ name: id ]); 
            },
            getContent : { id->
                return reportTemplateService.getContent([ name: id ]);
            }
        ] as SysReportTemplateSource;
        
        def custom_dir = SysReportLocalConf.getInstance().getCustomDir();
        def st = new SysReportTemplate( custom_dir.getPath(), reportInfo.filepath ); 
        def jreport = st.getReport( handler );

        conf.REPORT_CLASS_LOADER = new ExtReportTemplateClassLoader( st, getReportTemplateService() );

        def jprint = JasperFillManager.fillReport( jreport, conf, new ReportDataSource( data ));
        reportOutput = new ReportOutput( jprint, this ); 
        return true;
    }

    public boolean getHasParameters() {
        if(paramControls) return true;
        if(filterFields) return true;
        return  false;
    }

    def init() {
        if(reportid) {
            reportDef = getReportService().findReportDef( [name: reportid ] );
        }

        if(!reportDef) throw new Exception("report def is required in SysReportFormModel");
        if(!reportDef.template) throw new Exception("template is required in SysReportFormModel");

        def tmp = reportDef.template;
        if( tmp.trim().contains("#{") ) {
            try {
                tmp = ExpressionResolver.getInstance().evalString(tmp, query);    
            }
            catch(ex) {
                ex.printStackTrace();
            }
        } 
        reportInfo = reportTemplateService.getInfo( [name: tmp ] );

        if ( reportDef.parameters ) {
            loadParameters();
        }
        if ( hasParameters ) {
            mode = "parameter";
        }
        else {
            def v = loadReport();
            if(!v) throw new Exception("No records found for query");
            mode = "preview";
        }
        return mode;
    }
    
    def doBack() {
        mode = "parameter"
        return mode;
    }

    def doNext() {
        mode = "preview"
        def v = loadReport();
        if(!v) throw new Exception("There are no records found");
        return "preview";
    }

    void loadParameters() {
        paramControls = [];
        reportDef.parameters.findAll{ c-> !c.custom }.each {
            def b = [caption: it.caption, type: it.type, name: 'query.' + it.name, required: (it.prompt == 1) ];
            if ( it.type == 'lookup') {
                b.handlerObject = buildLookupHandler( it.handler, b, it.itemkey, it.itemvalue ); 
                b.expression = "#{DATA.title}";
            }
            paramControls << b;
        }
        filterFields = reportDef.parameters.findAll{ it.custom == 1 };
    }

    def buildLookupHandler( invokerType, data, itemKey, itemValue ) {
        return [
            getOpener: {
                def param = [:]; 
                param.onselect = { res-> 
                    data.value = ( itemKey ? res[itemKey] : res ); 
                    data.title = ( itemValue ? res[itemValue] : null );
                    binding?.refresh( data.name );
                }
                param.onempty = {
                    data.value = data.title = null; 
                    binding?.refresh( data.name );
                }
                return Inv.lookupOpener( invokerType, param );                 
            },

            onselect: { res-> 
                data.value = ( itemKey ? res[itemKey] : res ); 
                data.title = ( itemValue ? res[itemValue] : null );
                binding?.refresh( data.name );                
            }
        ] as LookupHandler; 
    }
}