package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;

class BplsFeeBFPListModel  {

    @Service("BplsFeeBFPService")
    def service;

    @Invoker
    def invoker;
    
    def task;
    def entity;
    def selectedItem;

    void init() {
    }

    String getTitle() { 
        return invoker.caption; 
    }
    
    def listModel = [
        fetchList: { o->
            def mm = [ applicationid: entity.objid, tag: invoker.role ]; 
            return service.getList( mm ); 
        }
    ] as DataListModel;
    
    boolean isMarkPaidEnabled() {
        if ( !selectedItem ) return false; 
        if ( !entity?.currenttask?.assignee?.objid ) return false; 
        if ( entity?.currenttask?.enddate ) return false; 
        return (selectedItem.paid.toString().matches("0|false")); 
    }

    boolean isMarkUnpaidEnabled() {
        if ( !selectedItem ) return false; 
        if ( !entity?.currenttask?.assignee?.objid ) return false; 
        if ( entity?.currenttask?.enddate ) return false; 
        return (selectedItem.paid.toString().matches("1|true")); 
    }

    void markAsPaid() {
        def mm = [ objid: selectedItem.objid, tag: invoker.role, state: 1 ]; 
        service.updateStatus( mm ); 
        listModel.reload();
    }

    void markAsUnpaid() {
        def mm = [ objid: selectedItem.objid, tag: invoker.role, state: 0 ]; 
        service.updateStatus( mm ); 
        listModel.reload();
    }
} 
