package com.rameses.app.common.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;
import com.rameses.common.*;

public class AppInfoComponentModel extends ComponentBean {
    
    def formInfos;

    String itemCaption = "caption";
    String itemType = "datatype";
    String itemCategoryExpr;  

    public void init() {
        //value should be a list
        if(getValue()==null) setValue([]);
        buildFormInfos(getValue());
    }    

    void buildFormInfos(infos) {
        def getprop = { obj, name ->
            return PropertyResolver.instance.getProperty(obj, name);
        };
        formInfos = [];
        infos.each { inf ->
            def item = [:];
            item.caption = (itemCaption=="caption")? inf.caption : getprop( inf, itemCaption );
            item.type = (itemType == "datatype") ? inf.datatype : getprop( inf, itemType );
            if( itemCategoryExpr ) {
                item.categoryid = ExpressionResolver.instance.evalString( itemCategoryExpr, [item:inf] );
            }
            else {
                item.category = inf.category;
            }
            item.data = inf;
            item.value = inf.value;

            //if item value is null we try to search the value from the data 
            if( item.value == null ) {
                if(item.type == "decimal") item.value = item.data.decimalvalue;
                else if(item.type == "integer") item.value =  item.data.intvalue;
                else if(item.type == "date") item.value =  item.data.datevalue;
                else if(item.type == "boolean") item.value = item.data.booleanvalue;  
                else item.value = item.data.stringvalue;    
            }

            //correct the types
            if(item.type == "boolean") {
                item.type = "yesno";
                if( item.value == null) item.value = false;
            }
            else if( item.type == 'decimal' ) {
                item.preferredSize = '150,20';
            }
            else if( item.type == 'integer' ) {
                item.preferredSize = '150,20';
            }
            else if( item.type == 'string') {
                item.type = 'text';
            }
            else if(item.type == 'text') {
                item.type = 'textarea';
                item.preferredSize = "0,60";
            }
            else if(item.type == "array") {
                //this still needs to be studied on how best to approach this
                /*
                if(inf.multiselect == 1) {
                    //multiselect mode    
                    item.expression = "#{item}";
                    item.preferredSize = '0,20';
                    item.editable = false;
                    item.type = "lookup";
                    def s = { o->
                        formPanel.updateBean( inf.name, item, o );
                        binding.refresh();
                    }
                    item.handlerObject = Inv.lookupOpener(inf.lookuphandler, [items:inf.arrayvalues,onselect:s, values: inf.value]);                    
                }
                else {    
                    item.type = "combo";
                    item.preferredSize = '0,20';
                    item.itemsObject = inf.arrayvalues;
                }
                */
            }
            
            if(inf.derived==true || inf.derived==1) {
                item.editable = false;    
            }

            formInfos << item;
        }
        formPanel.reload();
    }

    def formPanel = [
        getCategory: { key->
            return key;
        },
        updateBean: {name,value,item->
            item.data.value = value;
            if(item.type == "decimal") item.data.decimalvalue = value;
            else if(item.type == "integer") item.data.intvalue = value;
            else if(item.type == "date") item.data.datevalue = value;
            else if(item.type == "yesno") item.data.booleanvalue = value;  
            else item.data.stringvalue = value;         
        },
        getControlList: {
            return formInfos;
        }
    ] as FormPanelModel;
    
}