package com.rameses.app.common.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class InfoListComponentModel extends ComponentBean {

    boolean allowRules = true;
    boolean allowAdd = true;
    boolean allowEdit = true;
    boolean allowRemove = true;
    def handler;
    
    
    boolean showCategory = true;
    
    def listHandler = [
        isMultiSelect: {
            return true;
        },
        fetchList: { o->
            return handler.fetchItems();
        }
    ] as BasicListModel;
    
    public void init() {
       
    }
    
    void execRules() {
        if(!handler) throw new Exception("handler is required for execRules");
        def fetchHandler = { infos->
            return handler.executeRules( infos );        
        }
        def sh = { infos ->
            infos.each { it.auto = true }; 
            handler.onAddItem( infos );
            listHandler.reload();  
        }
        Modal.show( "common:appinfo_editor", [saveHandler :sh, fetchHandler: fetchHandler, initialInfos: getValue() ] );    
    }
    
    def addInfos() {
        def lookupHandler = handler.getLookupHandler();
        if(lookupHandler!=null) {
            def selectedItems;
            def s = { o->
                selectedItems = o;
                def sh = { infos->
                    infos.each { it.auto = false };
                    if(handler) handler.onAddItem( infos );
                    listHandler.reload();
                }
                return Inv.lookupOpener("common:appinfo_editor", [infos: selectedItems, saveHandler :sh ]);
            }
            
            if(lookupHandler instanceof String) {
                return Inv.lookupOpener( lookupHandler,  [onselect: s, multiSelect: true] );
            }
            else {
                return  lookupHandler.createInstance( [onselect: s, multiSelect: true] ); 
            }    
        }
        else {
            throw new Exception("Please specify a lookup handler");
        }
    }
    
    void removeInfos() {
        def selected = listHandler.selectedValue;
        if(!selected) throw new Exception("Please select values first");
        def hasAuto = selected.findAll{ it.auto == 1 || it.auto == true };
        if(hasAuto) throw new Exception("Cannot remove items that are auto generated. Use Clear instead");
        if(handler) handler.onRemoveItem( selected );
        listHandler.reload();   
    }
    
    void editInfos() {
        def selected = listHandler.selectedValue;
        if(!selected) throw new Exception("Please select values first");
        def sh = { infos->
            if(handler) handler.updateItem( infos );
            listHandler.reload();
        }
        Modal.show( "common:appinfo_editor", [infos: selected, saveHandler :sh ] );
    }
    
    void clearInfos() {
        def p = [:];    
        p.fields = [];
        p.fields << [caption:' ', datatype:'radio', name:'option', optionValue: 'auto', text:'Clear only auto items'];
        p.fields << [caption:' ', datatype:'radio', name:'option', optionValue: 'manual', text:'Clear only manual items'];
        p.fields << [caption:' ', datatype:'radio', name:'option', optionValue: 'all', text:'Clear All'];
        p.data = [:];
        p.handler = { o->
            def list = value;
            if( o.option == "auto" ) list = value.findAll{ it.auto == 1 || it.auto == true  };
            if( o.option != "auto" ) list = value.findAll{ it.auto != 1 && it.auto != true };
            if(handler) handler.onRemoveItem( list );
            listHandler.reload();
        }
        Modal.show("dynamic:form", p );
        
        
    }
}
