package com.rameses.app.common.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class PaymentListComponentModel extends ComponentBean {

    boolean showPaymentActions = true;
    
    def selectedPayment;
    
    def handler;
    def items;
    
    public void init() {
        if(handler) {
            handler.reload = {
                pmtListHandler.reload();
            }
        };
    }
    
    def pmtListHandler = [
        fetchList: { o->
            items = handler.fetchItems();
            return items;
        }
    ] as BasicListModel;
    
    def addPayment() {
        return Inv.lookupOpener("capture_single_bill_payment", [handler: handler ] );

        //return handler.showPayment( sh  );
        //this is applicable to manually added payments
        //return Inv.lookupOpener("capture_billitem_payment",[saveHandler:sh] )
    }
    
    void removePayment() {
        if(!items) return;
        def r = items[0];
        if(r.txnmode != 'CAPTURE') {
            throw new Exception("Only payments in CAPTURE mode can be deleted");
        };
        if(handler) {
            handler.removeItem( selectedPayment );
        }
        pmtListHandler.reload();
    }
    
    def viewPayment() {
        if(!selectedPayment) throw new Exception("Please select payment");
        return handler.viewItem(selectedPayment);
    }
    
   
}
