package com.rameses.app.common.components;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;

class PropertyListComponentModel extends ComponentBean {

    def selectedProperty;
    boolean showPropertyActions;
    
    public void init() {
        if(!getValue()) {
            setValue([]);
        }
    }
    
    def propertyListHandler = [
        fetchList: {
            return getValue();
        }
    ] as BasicListModel;
    
    def addProperty() {
        def h = { o->
            getValue().add( o );
            propertyListHandler.reload();
        }
        return Inv.lookupOpener("property_info:create", [handler:h] );
    }
    
    def editProperty() {
        if(!selectedProperty) throw new Exception("Select a property");
        def h = { o->
            selectedProperty.putAll( o );
            propertyListHandler.reload();
        }
        def v = [:];
        v.putAll(selectedProperty);
        return Inv.lookupOpener("property_info:open", [handler:h,entity:v ] );
    }
    
    void removeProperty() {
        if(!selectedProperty) throw new Exception("Select a property");
        def v = getValue().find{ it.key == selectedProperty.key };
        if(v) {
            getValue().remove(v);
            propertyListHandler.reload();
        }
    }
    
}
