package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

abstract class AbstractMonthlyBillModel  extends CrudFormModel {
    
    @Service("SysReportService")
    def reportSvc;

    public abstract def getBillService();
    
    public void afterReload() {;}
    public void afterCancel() {;}
    
    void movePrevBill() {
       if( !entity.prevbillid ) throw new Exception("Previous bill not found");
       entity = [objid: entity.prevbillid];
       reloadEntity();
       afterReload();
       binding.refresh();
    }
    
    void moveNextBill() {
       if( !entity.nextbillid ) throw new Exception("Next bill not found");
       entity = [objid: entity.nextbillid];
       reloadEntity();
       afterReload();
       binding.refresh();
    }
    
    def cancelBill() {
        if(!MsgBox.confirm("You are about to cancel this bill. Continue?")) return null;
        getBillService().cancelBill( [billid: entity.objid ] );
        afterCancel();
        return "_close";
    }
    
    def rebill() {
        def txndate = null;
        def h = { o->
            txndate = o;
        }
        Modal.show( "date:prompt", [handler: h] );
        if( !txndate ) return null; 
        getBillService().rebill( [billid: entity.objid, txndate: txndate ] );
        afterReload();
        binding.refresh();
    }
    
    def post() {
        if(!MsgBox.confirm("You are about to post this transaction. Proceed?")) return null;
        getBillService().post( [billid: entity.objid, assess_on_post: true ]  );
        entity.state = 'POSTED';
        reloadEntity();
        afterReload();
        binding.refresh();
    }
    
    def unpost() {
        if(!MsgBox.confirm("You are about to unpost this transaction. Proceed?")) return null;
        getBillService().unpost( [billid: entity.objid]  );
        entity.state = 'OPEN';
        reloadEntity();
        afterReload();
        binding.refresh();
    }
 
    def showReport( def p ) {
        def m = [:];
        m.query = [objid: entity.objid];
        m.reportDef = p;
        m.connection = getConnection();
        m.title = p.title;
        return Inv.lookupOpener( "sys_report_form", m );
    }

    def viewReport() {
        def category = entitySchemaName + ":form:reports";
        def opMenu = new PopupMenuOpener();
        try {
            def list = reportSvc.getListByCategory([ category: category ] );
            list.each {
                opMenu.add( new PopupAction(name:"showReport", caption:it.title, parameters: it, obj: this ) );      
            }
        } 
        catch(Throwable ign){;}
        if(opMenu.items.size()==0) throw new Exception("No reports defined in category in " + category);
        return opMenu;    
    }

    
}