package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;

class AddBillitemModel  {
    
    @Binding
    def binding;

    def entity;
    def saveHandler;
    def lookupHandler;
    
    boolean showYear = false;
    boolean showMonth = false;
    boolean showDuedate = true;
    
    @PropertyChangeListener
    def listener = [
        "entity.item" : {o->
            entity.amount = o.defaultvalue;
            if(entity.amount==null) entity.amount = 0;
            binding.refresh();
         }
    ]
    
    void init() {
        if(!entity) entity = [:];
        if(!entity.amtpaid) entity.amtpaid = 0;
    }
    
    def getLookupAccount() {
        return lookupHandler(); 
    }
    
    def doOk() {
        saveHandler( entity );
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    }
    
}