package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.seti2.models.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.enterprise.models.*;


class AppEntityEditorModel  {
    
    @Binding
    def binding;
    
    @Service(value="EntityService",connection="entity")
    def entitySvc;
    
    
    def entityTypes = ["INDIVIDUAL", "CORP", "MULTIPLE", "GOV"];
    def entity;
    
    def handler;
    boolean editable  = true;
    def idtype;
    
    void init() {
        if( entity.id == null ) entity.id = [type:[:]];
    }
    
    def lookupProfile() {
        def s = { o->
            def applicant = entitySvc.open([objid: o.objid]);
            entity.profileid = applicant.objid;
            entity.profileno = applicant.entityno;
            entity.name = applicant.name;
            entity.address = applicant.address;
            entity.entitytype = applicant.type;
            if( entity.entitytype == "INDIVIDUAL") {
                entity.lastname = applicant.lastname;
                entity.firstname = applicant.firstname;
                entity.middlename = applicant.middlename;
            }
            else if(entity.entitytype == "JURIDICAL") {
                entity.entitytype = applicant.orgtype; 
            }
            binding.refresh();
        };
        return Inv.lookupOpener("entity:lookup", [onselect:s]);
    }
    
    def doOk() {
        if( editable ) {
            if( entity.address.type == "local") {
                entity.resident = 1;
            }
            else {
                entity.resident = 0;
            }
            if( entity.entitytype == "INDIVIDUAL" ) {
                entity.name = entity.lastname + ", " + entity.firstname;
                if( entity.middlename ) {
                    entity.name += " " + entity.middlename.substring(0,1)+".";
                }
            }
            handler( entity );            
        }
        return "_close";
    }
    
    def doCancel() {
        return "_close";
    }
    
}