package com.rameses.app.common.models;

import com.rameses.rcp.annotations.*
import com.rameses.rcp.common.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.common.*
import java.rmi.server.*;
import com.rameses.util.*;
import com.rameses.osiris2.reports.*;
import com.rameses.seti2.models.*;

public class ItemAccountModel extends CrudFormModel {
    
    def itemGroupList;
    
    public def getItemTypes() {
        return ["FEE", "SURCHARGE", "INTEREST" ];
    }
    
    public boolean getShowItemGroup() {
         def showItmGrp = workunit.info.workunit_properties.showItemGroup;
         if("false".equals(showItmGrp)) {
             return false;
         }
         else {
             return true;
         }
    }
    
    void afterInit() {
        if( showItemGroup ) {
            def m = [_schemaname:getSchemaName() + "_group"];
            m.where = ["1=1"];
            m.orderBy = "idx ASC";
            itemGroupList  = queryService.getList(m);
        }
    }
   
    void afterCreate() {
        entity.objid = null;
    }
    
    def mapAccount() {
        def s = { o->
            def m = [_schemaname:getSchemaName()];
            m.objid = entity.objid;
            m.item = o;
            persistenceService.update( m );
            reloadEntity();
        }
        return Inv.lookupOpener("itemaccount:lookup", [onselect: s] ); 
    }

    def unmapAccount() {
        def m = [_schemaname:getSchemaName()];
        m.objid = entity.objid;
        m.item = [objid:"{NULL}",code:"{NULL}",title:"{NULL}",fund:[objid:"{NULL}", title:"{NULL}"]];
        persistenceService.update( m );
        reloadEntity();
    }
    
}