package com.rameses.enterprise.treasury.cashreceipt; 

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.util.*;
import com.rameses.enterprise.models.*;
        
public class PaymentOrderCashReceiptModel extends AbstractCashReceipt {

    @Script("User")
    def user;
    
    void init() {
        super.init();
        entity.amount = getTotalAmount();
    }

    void loadBarcode() {
        init();
    }

    def itemListModel = [
        fetchList: { o->
            return entity.items;
        }
    ] as BasicListModel;
            
    def selectedItem;
     
    def getTotalAmount() {
        return NumberUtil.round( entity.items.sum{ it.amount } );  
    }   
      
} 