package com.rameses.enterprise.treasury.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.reports.*;
import com.rameses.seti2.models.*;
import com.rameses.util.*;
import com.rameses.rcp.framework.ValidatorException;


class AFTxnMainModel extends CrudPageFlowModel {

    @Service("DateService")
    def dateSvc;
    
    def txnTypes;
    def txntype;
    def dtfiled;
    boolean withrequest = false;
    def afrequest;
    def reqtype = null;
    def handler;
    def mode;
    

    def startCreate() {
        afrequest = null; 
        dtfiled = dateSvc.getBasicServerDate();
        try {
            txnTypes = Inv.lookupOpeners("aftxn:handler").collect { [caption:it.caption, name:it.properties.name] };
        }
        catch(e){;}
        mode  = "create";
        return super.start("default");
    }
    
    def startOpen() {
        entity._schemaname = "aftxn";
        entity = persistenceService.read( entity );
        mode = "open";
        if( entity.state  == "DRAFT") {
            buildOpener("open");
            return super.start("process");
        }
        else {
            return super.start("view");
        }
    }
    
    void initCreate() {
        initData();
        buildOpener("create");
    }

    
    void initData() {
        entity = [:];
        entity.state = "DRAFT";
        entity.items = [];
        entity.txntype = txntype;
        entity.dtfiled = dtfiled;
        if(withrequest) {
            def req = persistenceService.read( [_schemaname:'afrequest', objid: afrequest.objid ] );
            entity.request = [objid:req.objid , reqno: req.reqno];
            entity.issueto = req.requester;
            entity.respcenter = req.respcenter;
            req.items.each {
                def m = [:];
                m.item = it.item;
                m.unit = it.unit;
                m.qtyrequested = it.qty;
                m.qty = it.qty;
                m.qtyserved = 0;
                m.cost = it.afunit.saleprice;
                m.txntype = req.reqtype;
                if(m.txntype.matches("ISSUE")) {
                    m.txntype = null;
                }
                m.afunit = it.afunit;
                m.linetotal = (m.qty ? m.qty : 0) * (m.cost ? m.cost : 0.0);
                entity.items << m;
            };
        }
    }
    
    void buildOpener(def _mode) {
        String hname = "aftxn:handler:"+ entity.txntype.toLowerCase();
        try {
            def h = [
                back : {
                    def op = super.signal("back");
                    binding.fireNavigation( op );
                },
                forward: {
                    entity = persistenceService.read( [_schemaname:'aftxn', objid: entity.objid ] );                    
                    def op = super.signal("forward");
                    binding.fireNavigation( op );
                },
                exit: {
                    def op = super.signal("exit");
                    binding.fireNavigation( op );
                }
            ];
            handler = Inv.lookupOpener(hname, [handler: h, entity: entity, afrequest: entity.request, mode: _mode ]);
        }
        catch(e) {
            throw new Exception("Txn Type " + hname + " not found!" );
        }    
    }    
    
    
     //the only lookup here is for the request because the other request os for purchase (af receipt)
    public def getLookupRequest() {
        if( txntype == "ISSUE" ) {
            return Inv.lookupOpener( "afrequest_collection:lookup", [:] );
        }
        else {
            return Inv.lookupOpener( "afrequest_purchase:lookup", [:] );
        }
    }

    public def getInfo() {
        return TemplateProvider.instance.getResult( "com/rameses/enterprise/treasury/views/AFTxnViewInfo.gtpl", [entity:entity] );
    }
    
    /*
    void clearItems() {
        afType = null;
        entity.issuefrom = null;
        entity.issueto = null;
        entity.respcenter = null;        
        afListModel.reload();
    }
    */
   
    //for printing purposes
    def preview() {
        buildCompatibility( entity ); 

        def totalcost = 0.0; 
        entity.items.each{ afi-> 
            afi.items.each{ 
                it.txntype = afi.txntype.toString().toUpperCase(); 
                if ( it.txntype == 'COLLECTION') {
                    it.totalcost = (it.cost ? it.cost : 0.0) * it.stubcount; 
                }
                else if ( it.txntype == 'SALE') { 
                    def basecost = (it.salecost ? it.salecost : it.cost); 
                    it.totalcost = (basecost ? basecost : 0.0) * it.stubcount; 
                }
            }

            afi.totalcost = afi.items.sum{( it.totalcost ? it.totalcost : 0.0 )} 
            afi.totalcost = (afi.totalcost ? afi.totalcost : 0.0); 
            totalcost += afi.totalcost; 
        } 
        entity.totalcost = totalcost; 
        
        def params = [reportHandler: [:]]; 
        params.title = 'AF Transaction Report'; 

        def txntype = entity.txntype.toString().toLowerCase();
        if ( txntype.matches('return|transfer|manual_issue')) {
            def inv_type = 'aftxn_'+ txntype +'_report'; 
            def op = Inv.lookup( inv_type );
            if ( !op ) {
                MsgBox.alert('No available report for this kind of transaction'); 
                return null; 
            }

            op = Inv.lookupOpener( inv_type, [ entity: entity ]);
            op.target = 'process'; 

            def oHandle = op.handle; 
            params.reportHandler.getData = { return oHandle.data; }
            params.reportHandler.getReportName = { return oHandle.reportName; }
            params.reportHandler.getSubReports = { return oHandle.subReports; }
        }
        else if ( txntype.matches('issue|purchase_receipt')) {
            def path = 'com/rameses/gov/treasury/ris/report/';
            
            def mainreport = path + 'ris.jasper';
            def subreports = new SubReport[1]; 
            subreports[0] = new SubReport("ReportRISItem", path + "risitem.jasper"); 

            params.reportHandler.getData = { return entity; }
            params.reportHandler.getReportName = { return mainreport; }
            params.reportHandler.getSubReports = { return subreports; }
        }
        
        if ( params.reportHandler && !params.reportHandler.isEmpty()) {
            return Inv.lookupOpener('simple_form_report', params);	
        }
        
        MsgBox.alert('No available report for this kind of transaction'); 
        return null; 
    }
    
    private void buildCompatibility( data ) {
        data.reqno = data.request?.reqno;
        if ( !data.reqno ) data.reqno = data.controlno;
        if ( !data.requester ) data.requester = data.issueto; 
        data.items.each{ o-> 
            if ( o.qtyreceived == null ) o.qtyreceived = o.qtyserved;
        }
        if ( !data.reqtype ) {
            data.reqtype = null; 
            if ( data.reqtype.toString().toUpperCase().startsWith('PURCHASE')) {
                data.reqtype = 'PURCHASE'; 
            } else if ( data.reqtype.toString().toUpperCase().startsWith('ISSU')) {
                data.reqtype = 'ISSUANCE'; 
            }
        }
        data.totalcost = 0;
        data.items.each{ o-> 
            data.totalcost += (o.linetotal ? o.linetotal : 0.0); 
            if ( o.series ) return; 
            def buff = []; 
            if ( o.afunit?.formtype == 'serial') {
                o.items.each {
                    def sb = new StringBuilder(); 
                    sb.append( it.startseries.toString()).append(" - ");
                    sb.append( it.endseries.toString()).append(" ( "); 
                    if ( it.startstub == it.endstub ) {
                        sb.append( it.startstub.toString()); 
                    }
                    else {
                        sb.append( it.startstub.toString()).append(" - "); 
                        sb.append( it.endstub.toString()); 
                    }
                    sb.append(" )");
                    
                    buff << sb.toString();  
                }
            } 
            else if ( o.afunit?.formtype != 'serial') { 
                o.items.each {
                    def sb = new StringBuilder(); 
                    sb.append('Stub No. ( '); 
                    if ( it.startstub == it.endstub ) {
                        sb.append( it.startstub.toString()); 
                    }
                    else {
                        sb.append( it.startstub.toString()).append(" - "); 
                        sb.append( it.endstub.toString()); 
                    }
                    sb.append(" )");

                    buff << sb.toString();  
                }
            } 
            o.series = buff.join(', ');
        }
    }  
} 