package com.rameses.treasury.common.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.* 
import com.rameses.util.BreakException

class BarcodeLauncherModel extends CrudFormModel {
    
    void afterInit() {
    }
    
    void afterCreate() {
        entity.state = 'ACTIVE';
    }
    
    void activate() {
        if ( entity.state.toString().toUpperCase() == 'ACTIVE' )
            throw new Exception("Record is already activated");
        
        def param = [ _schemaname: getSchemaName(), _action: 'activate' ];
        param.objid = entity.objid;
        param.state = 'ACTIVE';
        persistenceSvc.update( param ); 
        entity.state = param.state; 

        notifyDepends('status');
        refreshCallerListHandler();
    }

    void deactivate() {
        if ( entity.state.toString().toUpperCase() != 'ACTIVE' )
            throw new Exception("Record is already deactivated");
        
        def param = [ _schemaname: getSchemaName(), _action: 'deactivate' ];
        param.objid = entity.objid;
        param.state = 'INACTIVE';
        persistenceSvc.update( param ); 
        entity.state = param.state; 

        notifyDepends('status');
        refreshCallerListHandler();
    } 
    
    void refreshCallerListHandler() {
        def _list_handler = callbackListHandler;
        if ( caller instanceof BarcodeLauncherModel ) {
            _list_handler = caller.callbackListHandler;
        }
        if ( _list_handler ) {
            _list_handler.doSearch(); 
        }
    }
    
    void notifyDepends( name ) {
        def _binding = this.binding;
        if ( caller instanceof BarcodeLauncherModel ) {
            _binding = caller.binding;
        }
        if ( _binding ) {
            _binding.notifyDepends( name ); 
        }
    } 
}