package com.rameses.enterprise.treasury.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.reports.*;
import com.rameses.util.*;
import com.rameses.enterprise.treasury.util.CashReceiptPrintUtil;

class CashReceiptIssueModel extends CashReceiptAbstractIssueModel  {

    @Service('Var')
    def varSvc;

    def handler;
    boolean showPrintDialog = false;
    
    def printPreviewOpener;
    
    String formName = "cashreceipt"; 

    //default to af51
    public String getDefaultAfType() {
        return "51";
    }
    
    public String getFormType() {
        return "serial";
    }

    def processHandler = [
        back : {
            def op = super.signal("back");
            binding.fireNavigation( op );
        },
        forward: { o-> 
            if ( o ) entity.putAll( o ); 
                        
            try { 
                def op = super.signal("forward");
                binding.fireNavigation( op ); 
            }
            finally {
                if ( mode == "ONLINE" ) { 
                    if ( o.hasCustomPrinting ) { 
                        // it has a custom printing facility, so will do nothing 
                    } 
                    else { 
                        printReceipt();
                    }
                }
            }
        }
    ];
    
    void launchNew() {
        createNew();
        
        def m = [entity: entity, afcontrol: afcontrol, mainProcessHandler: processHandler];
        handler = Inv.lookupOpener("cashreceipt:"+ collectionType.handler, m); 
    }
    
    void cleanUp() {
        entity = [:];
        handler = null;
    }

    
    def getInfoHtml() {
        return TemplateProvider.instance.getResult( "com/rameses/enterprise/treasury/cashreceipt/cashreceipt.gtpl", [entity:entity] );
    }
    
    def loadBarcode() {
        def retval = null;
        def h = { o->
            cleanUp();
            retval = o;
            
            mode = "ONLINE";
            collectionType = o.collectiontype;
            afType = o.collectiontype.formno;
            
            //loaded collection type
            collectionTypes.mode = "ONLINE";
            collectionTypes.afType = afType; 
            
            //initialize the entity. If there is _paymentorderid 
            //it means there is a related payment order for this.
            createNew();

            entity.payer = o.payer;
            entity.paidby = o.paidby;
            entity.paidbyaddress = o.paidbyaddress;
            entity.remarks = o.remarks;
            entity.items = o.items;
            entity.amount = o.amount;
            entity._paymentorderid = o._paymentorderid;
            entity._connection = o._connection;
        }
        
        Modal.show( "cashreceipt_barcode", [handler: h] );
        if(!retval) return null;

        def pp = [:];
        pp.barcodeid = retval.barcodeid;
        pp.barcodeparams = retval.barcodeparams;
        pp._paymentorderid = entity._paymentorderid;

        //also place in entity
        pp.entity = entity;
        pp.mainProcessHandler = processHandler;

        def pfix = "cashreceipt:"+ collectionType.handler;
        
        def invokerTypes = [];
        if ( retval.barcodekey ) {
            // check the old implementation first before 
            // proceeding to the new implementation
            // NOTE: This is for backward compatibility
            invokerTypes << "cashreceipt:barcode:"+ retval.barcodekey;
        }
        invokerTypes << pfix +":barcode";
        invokerTypes << pfix;
        
        for ( invtype in invokerTypes ) {
            try { 
                handler = Inv.lookupOpener( invtype, pp );
            } catch(e){;} 
            
            if ( handler ) break; 
        }
        
        if ( !handler ) {
            throw new Exception("workunit invokers "+ pfix+":barcode or " + pfix + " not found!");    
        }
        return super.signal("movenext");
    }
    
    public void printReceipt() {
        if ( afcontrol?.afunit?.cashreceiptprintout ) { 
            def u = new CashReceiptPrintUtil( binding: binding ); 
            u.showPrinterDialog = ( entity._options?.canShowPrinterDialog.toString() == 'false' ? false : true ); 
            u.print( afcontrol.afunit.cashreceiptprintout, entity );
        } 
        else {
            MsgBox.alert("Unable to print receipt. Please define a setting for cashreceipt printout in AF Unit"); 
        }
        
        def handlerModel = handler;
        if ( handler instanceof Opener ) {
            handlerModel = handler.handle; 
        }
        if ( handlerModel && handlerModel.metaClass.respondsTo( handlerModel, 'afterPrintReceipt' )) {
            handlerModel.afterPrintReceipt(); 
        }
    }
    
    public void reprintReceipt() {
        if ( afcontrol?.afunit?.cashreceiptprintout ) { 
            def u = new CashReceiptPrintUtil( binding: binding ); 
            u.showPrinterDialog = ( entity._options?.canShowPrinterDialog.toString() == 'false' ? false : true );             
            u.reprint( afcontrol.afunit.cashreceiptprintout, entity );
        } 
        else {
            MsgBox.alert("Unable to print receipt. Please define a setting for cashreceipt printout in AF Unit"); 
        }
        
        def handlerModel = handler;
        if ( handler instanceof Opener ) {
            handlerModel = handler.handle; 
        }
        if ( handlerModel && handlerModel.metaClass.respondsTo( handlerModel, 'afterReprintReceipt' )) {
            handlerModel.afterReprintReceipt(); 
        }        
    } 
    
    public void printReceiptDetail() {
        if ( afcontrol?.afunit?.cashreceiptdetailprintout ) {
            def u = new CashReceiptPrintUtil( binding: binding ); 
            u.printDetails( afcontrol.afunit.cashreceiptdetailprintout, entity );
        } 
        else {
            MsgBox.alert("Unable to print receipt detail. Please define a setting for cashreceipt detail printout in AF Unit"); 
        }
    }
        
    def void_requires_approval; 
    boolean isVoidRequiresApproval() {
        if ( void_requires_approval == null ) {
            def sval = varSvc.get('cashreceipt_void_requires_approval'); 
            void_requires_approval = ( "true".equals(sval.toString()) ? true : false); 
        }
        if ( void_requires_approval instanceof Boolean ) {
            return (void_requires_approval ? true : false); 
        }
        return false; 
    }

    public void voidReceipt() { 
        if ( entity.voided.toString().matches('1|true')) {
            MsgBox.alert('Cash Receipt is already voided'); 
        } else {
            Modal.show( "void_cashreceipt", [applySecurity : isVoidRequiresApproval(), receipt: entity ]);
        }
    }

    public viewCollectionSummary() {
        def tag = invoker?.properties?.tag; 
        Modal.show( "cashreceipt_collection_summary:view", [tag: tag]);
    } 
}    