package com.rameses.enterprise.treasury.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.* 

class CashReceiptPaymentNonCashListModel extends CrudSubListModel {

    public void initColumn( c ) { 
        if ( c.name == 'receipt.collector.name' ) { 
            c.caption = 'Collector'; 
        } 
        else if ( c.name == 'amount' ) { 
            c.width = 100; 
            c.maxWidth = 120;
            c.type = 'decimal';
            c.caption = 'Amount';
        } 
        else if ( c.name == 'fund.title' ) { 
            c.width = 100; 
            c.caption = 'Fund';
        } 
    }

    public def getCustomFilter() {
        return ["refid=:id", [id:masterEntity.objid] ]; 
    }

    public def open() {
        if(!selectedItem) throw new Exception("Please select an item");

        def op = Inv.lookupOpener("cashreceipt:open", [entity: [ objid: selectedItem.receiptid] ] );
        op.target = "popup";
        return op;
    }
} 