package com.rameses.enterprise.treasury.models; 

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class CashReceiptRevertVoidModel {

    @Service("CashReceiptVoidService")
    def service;

    @Binding
    def binding;

    @Caller
    def caller;
    
    def data; 
    def handler; 

    void init() {
        data = [:];
    } 
    
    def getReceipt() { 
        return caller?.entityContext; 
    } 

    def doOk() {
        if( MsgBox.confirm( "You are about to revert a void receipt. Continue?")) {
            data.objid = receipt.objid; 
            data.receipt = [ 
                objid: receipt.objid, 
                formno: receipt.formno, 
                collectiontype: receipt.collectiontype, 
                org: receipt.org 
            ]; 
            service.revert( data ); 
            receipt.voided = 0;
            
            if ( handler ) handler(); 
            else { 
                try { 
                    if ( caller.metaClass.respondsTo(caller, 'refresh')) {
                        caller.refresh(); 
                    } else if ( caller.metaClass.hasProperty(caller, 'binding')) {
                        caller.binding.refresh(); 
                    } 
                } catch(Throwable t) {
                    t.printStackTrace(); 
                } 
            } 
            return "_close";
        } 
    } 

    def doCancel() {
        return "_close";
    }
}      
