package com.rameses.enterprise.treasury.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class CollectionTypeHandlerLookupModel implements SimpleLookupDataSource {

    def handlerTypes;
    
    LookupSelector selector; 
    
    void init() {
        handlerTypes = []; 

        def invokers = Inv.lookup("collectiontype:handler");
        def colltypes = invokers.collect{ it.properties.name }.findAll{( it )}.unique();
        colltypes.sort{ it } 
        colltypes.each{ 
            handlerTypes << [objid: it, name: it]
        }
    }

    def selectedEntity;
    def listHandler = [
        getColumnList: {
            return [
               [name: 'objid', caption: 'Name'] 
            ]; 
        },
        
        fetchList: {
            return handlerTypes;
        }
    ] as DataListModel; 
    
    void setSearchText( String searchtext ) {
    }

    void setSelector(LookupSelector selector) {
        this.selector = selector; 
    } 
    
    def doCancel() {
        if ( selector ) {
            selector.cancelSelection(); 
        }
        return '_close';
    }
    
    def doSelect() {
        if ( selector ) {
            selector.select( selectedEntity );  
        }
        return '_close';
    }
} 