package com.rameses.enterprise.treasury.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;

class DepositSlipModel extends CrudFormModel {

    @Service("DepositSlipService")
    def depositSlipSvc;
    
    def checkList;
    int checksCount;
    
    void afterInit() {
        def m = [_schemaname: 'checkpayment'];
        m.findBy = [depositslipid : entity.objid];
        m.orderBy = "refno";
        checkList = queryService.getList( m );
        checksCount = checkList.size();
    }
    
    void changeState( def state, def params ) {
        def m = [_schemaname:'depositslip'];
        m.findBy = [objid: entity.objid];
        m.state = state;
        if( params ) m.putAll( params );
        persistenceService.update(m);        
        entity.state = state;
        if( params ) entity.putAll( params );
    }
    
    void approve() {
        changeState("APPROVED", null);
    }
    
    void disapprove() {
        changeState("DRAFT", null);
    }
    
    void print() {
        def bh = null;
        if( entity.deposittype == "CASH" ) {
            bh = entity.bankaccount.bank.cashreport;
        }   
        else if( entity.deposittype == "CHECK"){
            bh = entity.bankaccount.bank.checkreport;
        }
        
        if ( !bh ) throw new Exception("Please specify a cash and check deposit handler in the bank ");
        
        def br = "depositslip_printout:" + bh;
        try {
            def op = Inv.lookupOpener(br, [entity: entity ]);
            if ( !op ) throw new Exception("Opener " + br + " not found. Please ensure it is included in the project");
            
            op.target = "process";
            Inv.invoke(op);
        }
        catch(ex) {
            MsgBox.err( ex );
        }
    }
    
    void markAsPrinted() {
        changeState( "PRINTED", null );
    }
    
    void validate() {
        def callbackHandler = { o-> 
            changeState( "VALIDATED", [validation: o]);
        }
        validateImpl( entity, callbackHandler ); 
    }
    
    void validateBatch( items ) {
        def root = this;
        def callbackHandler = { o-> 
            items.each{
                root.entity = it; 
                changeState( "VALIDATED", [validation: o]);
            }
        }
        
        validateImpl( items, callbackHandler );         
    }
    
    void validateImpl( data, callbackHandler ) {
        def m = [:];
        m.fields = [
            [caption: 'Validation Ref No', name:'refno', required:true],
            [caption: 'Validation Ref Date', name:'refdate', required:true, datatype:'date'],            
        ];

        if ( data instanceof Map ) {
            m.data = data.validation;
        }
        else if ((data instanceof List) && data.size() == 1 ) {
            m.data = data.first().validation;
        }

        if ( m.data == null ) m.data = [:]; 

        m.handler = { callbackHandler( it ) } 
        Modal.show( "dynamic:form", m, [title:"Validate Deposit Slip"] );        
    }
    
    def checkListModel = [
        fetchList : {
            return checkList;
        }
    ] as BasicListModel;
    
}    