package com.rameses.enterprise.treasury.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;


class DepositVoucherInitialModel extends CrudListModel {

    @Service("DepositVoucherService")
    def depositSvc;    
    
    def df = new java.text.SimpleDateFormat("yyyy-MM-dd");
    def amount = 0;
    int step = 1;
   
    def selectedItem;
    
    
    def collectionListModel = [
        isMultiSelect: {
            return true;
        },
        fetchList: { o->
            def m = [_schemaname: 'collectionvoucher' ];
            m.where = [" depositvoucherid IS NULL AND state = 'POSTED' AND (totalcash + totalcheck) > 0 "];
            m.orderBy = "controldate";
            return queryService.getList( m ).each{
                it.totalamount = it.totalcash + it.totalcheck; 
            } 
        },
        onOpenItem: {o,col->
            def op = Inv.lookupOpener("collectionvoucher:open", [entity: o] );
            op.target = "popup";
            return op;
        },
        afterSelectionChange: { o ->
            amount = 0.0; 
            collectionListModel.selectedValue.each{
                amount += (it.totalcash + it.totalcheck); 
            } 
            binding.notifyDepends("selectedItem");
        }
    ] as BasicListModel;
    
    void doRefresh() {
        collectionListModel.reload(); 
    }
    
    def submit() {
        def selectedList = collectionListModel.getSelectedValue();
        if(!selectedList) throw new Exception("Please select at least one entry");
        if( amount <= 0 ) throw new Exception("Amount must be greater than zero");
        if(!MsgBox.confirm("You are about to create a deposit voucher. Proceed?")) return null;

        def m = [:];
        m.amount = amount; 
        m.items = selectedList*.objid;
        m = depositSvc.create( m );
        
        step = 2;
        binding.fireNavigation('step2'); 

        def async = [
            run: {
                try {
                    def op = Inv.lookupOpener( "depositvoucher:open", [entity: [objid: m.objid]]);
                    op.target = 'window'; 
                    Inv.invoke( op );  
                }
                catch(err) {
                    MsgBox.err( err ); 
                }
                finally {
                    binding.fireNavigation('_close'); 
                }
            } 
        ] as AsyncAction; 
        
        return async; 
    }
}    