package com.rameses.enterprise.treasury.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.CrudLookupModel;

class EFTPaymentLookupModel extends CrudLookupModel {
            
    def fundids;

    public void initColumn( c ) { 
        if ( c.name == 'refno') {
            c.width = 100; 
            c.maxWidth = 140; 
        } 
        else if ( c.name == 'refdate') {
            c.width = 100; 
            c.maxWidth = 120; 
            c.type = "date";
            c.outputFormat = "yyyy-MM-dd";
        }
        else if ( c.name == 'payer.name') {
            c.width = 150; 
            c.caption = 'Payer';
        }
        else if ( c.name == 'bankaccount.code') {
            c.width = 120; 
            c.maxWidth = 140;
        }
        else if ( c.name == 'bankaccount.bank.name') {
            c.width = 140; 
            c.caption = 'Bank';
        }
        else if ( c.name == 'amount') {
            c.width = 120; 
            c.maxWidth = 140;
            c.type = "decimal";
            c.outputFormat = "#,##0.00";
        }
    }     
    
    def getCustomFilter() {
        if(fundids) {
            return [ "state='DRAFT' AND fund.objid IN ('" + fundids.join("','") + "')" ]; 
        }
        return null;
    }

}