package com.rameses.enterprise.treasury.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.CrudFormModel; 
import com.rameses.util.BreakException;

class PaymentOrderModel extends CrudFormModel {
    
    void afterCreate() {
        def ctx = com.rameses.rcp.framework.ClientContext.currentContext;
        
        entity.items = [];
        boolean pass = false;
        def h = [:];
        
        if ( ctx.headers.ORGROOT.toString() != '1' ) { 
            h.query = [ orgid: ctx.headers.ORGID ]; 
        } 
        
        h.onselect = { o->
            entity.collectiontype = o;
            pass = true;
        }
        Modal.show( "collectiontype:paymentorder:lookup", h )
        if(!pass) throw new BreakException();
    }
    
    def getQuery() {
        def p = [:];
        p.put("txntype", "cashreceipt" );
        p.put("collectiontype", entity.collectiontype);
        return p;
    }
    
    
    @PropertyChangeListener
    def listener = [
        "entity.payer": { o->
            entity.paidby = o.name;
            entity.paidbyaddress = o.address.text;
            binding.refresh();
        }
    ];
    
    void afterSave() {
        MsgBox.alert( "Order of payment number " + entity.objid );
    }    
} 