package com.rameses.gov.treasury.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.seti2.models.*;
import com.rameses.rcp.framework.ValidatorException;

class CashTicketVoidModel  {

    @Binding
    def binding;

    @Caller
    def caller;

    @Script("User")
    def user;
    
    @Service("CashTicketVoidService")
    def service;
    
    boolean allowCreate = false;
    boolean allowEdit = false;
    boolean applySecurity = false;

    def username;
    def password;
    def remarks;
    
    def entity;
    def receipt;
    def handler;

    void init() { 
        if (receipt.voided) {
            throw new Exception("This transaction is already voided") 
        } 
        
        entity = [receipt: receipt];
    }

    def doOk() {
        def prefixMsg = "";
        
        if( MsgBox.confirm("You are about to void this cash ticket. Continue?")) {
            if( applySecurity ) {
                entity.username = username;
                entity.password = user.encodePwd( password, username );
            }
            entity.applysecurity = applySecurity;
            entity.reason = remarks;
            entity.receipt = receipt; 
            service.post( entity );

            receipt.voided = true;
            receipt._closeReceipt = true;
            
            if ( handler ) { 
                handler(receipt);
            } 
            return "_close";
        } 
    } 

    def doCancel() {
        return "_close";
    }
}    