package treasury.monitoring.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class CollectionAndDepositSummaryReportModel extends AsyncReportController {

    @Service('monitoring/CollectionAndDepositSummaryReportService') 
    def svc; 
    
    @Script('ReportPeriod') 
    def reportPeriod;
    
    String title = 'Collections and Deposits Summary';
    String reportpath = 'treasury/monitoring/report/';

    def data;
    def tag;
    def periods; 
    
    def domains = [];
    
    def templates = [ 
        [objid:'default', name:'Default', template: 'collection_and_deposit_summary.jasper']
    ]; 
    
    void doInit( inv ) { 
        tag = inv?.properties?.tag; 
        init();
    } 
    
    def initReport() { 
        def outcome = super.initReport();
        
        domains = [];
        domains << [name: 'Default']; 
        
        def resp = svc.initReport([ tag: tag ]); 
        periods = reportPeriod.types.findAll{( it.type.matches('monthly'))}
        entity.period = periods.find{( it.type == 'monthly' )}         
        entity.year = resp.year; 
        
        if ( resp.domains ) {
            domains.addAll( resp.domains ); 
        }
        return outcome; 
    }

    public String getReportName() {
        return reportpath + entity.template?.template; 
    }


    void buildReportData(entity, asyncHandler) {
        def m = reportPeriod.build( entity.period.type, entity ); 
        entity.startdate = m.startdate;
        entity.enddate = m.enddate; 
        
        svc.getReport( entity, asyncHandler );
    }
    
    void buildResult( o ) {
        data = o; 
    }
    
       
    Map getParameters() { 
        return data?.header; 
    } 

    boolean isDynamic() { 
        return true; 
    } 
    
    
    def controls = [
        [type:"combo", caption:'Domain', name:'entity.domain', required:true, items:'domains', expression:'#{item.name}', preferredSize:'0,20', captionWidth:100, allowNull: false],
        [type:"combo", caption:'Template', name:'entity.template', required:true, items:'templates', expression:'#{item.name}', preferredSize:'0,20', captionWidth:100, allowNull: false],

        [type:"combo", caption:'Period', name:'entity.period', required:true, items:'periods', expression:'#{item.title}', preferredSize:'100,20', captionWidth:100, allowNull: false],
        [type:"date", caption:'Date', name:'entity.date', required:true, preferredSize:'100,20', captionWidth:100, depends:'entity.period', visibleWhen:'#{entity.period?.type == "daily"}'],
        [type:"integer", caption:'Year', name:'entity.year', required:true, preferredSize:'100,20', captionWidth:100, depends:'entity.period', visibleWhen:'#{entity.period?.type == "monthly"}'],
        [type:"combo", caption:'Month', name:'entity.month', required:true, items:'reportPeriod.months', expression:'#{item.title}', preferredSize:'100,20', captionWidth:100, depends:'entity.period', visibleWhen:'#{entity.period?.type == "monthly"}']
    ]; 
    
    def formControl = [
        getControlList: {
            return controls;
        } 
    ] as FormPanelModel;    
}