package treasury.monitoring.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

class UnremittedCollectionReportModel extends AsyncReportController {

    @Service('monitoring/UnremittedCollectionReportService') 
    def svc; 
    
    @Script('ReportPeriod') 
    def reportPeriod;
    
    String title = 'Unremitted Collections Report';
    String reportpath = 'treasury/monitoring/report/';

    def data;
    def tag;
    
    def domains = [];
    
    def templates = [ 
        [objid:'templateA', name:'Template A', template: 'unremitted_collection_templateA.jasper']
    ]; 
    
    def periods = [
        [type:'asofyear', title:'As of Year'],        
    ];
    
    void doInit( inv ) { 
        tag = inv?.properties?.tag; 
        init();
    } 
    
    def initReport() { 
        def outcome = super.initReport();
        
        domains = [];
        domains << [name: 'Default']; 
        
        def resp = svc.initReport([ tag: tag ]); 
        entity.period = periods.first();
        entity.year = resp.year; 
        
        if ( resp.domains ) {
            domains.addAll( resp.domains ); 
        }
        return outcome; 
    }

    public String getReportName() {
        return reportpath + entity.template?.template; 
    }


    void buildReportData(entity, asyncHandler) {
        //def m = reportPeriod.build( entity.period.type, entity ); 
        
        svc.getReport( entity, asyncHandler );
    }
    
    void buildResult( o ) {
        data = o; 
    }
    
       
    Map getParameters() { 
        return data?.header; 
    } 

    boolean isDynamic() { 
        return true; 
    } 
    
    
    def controls = [
        [type:"combo", caption:'Domain', name:'entity.domain', required:true, items:'domains', expression:'#{item.name}', preferredSize:'0,20', captionWidth:100, allowNull: false],
        [type:"combo", caption:'Template', name:'entity.template', required:true, items:'templates', expression:'#{item.name}', preferredSize:'0,20', captionWidth:100, allowNull: false],

        [type:"combo", caption:'Period', name:'entity.period', required:true, items:'periods', expression:'#{item.title}', preferredSize:'100,20', captionWidth:100, allowNull: false],
        [type:"integer", caption:'Year', name:'entity.year', required:true, preferredSize:'100,20', captionWidth:100, depends:'entity.period', visibleWhen:'#{entity.period?.type.toString().matches("asofyear|yearly|monthly") == true}']
    ]; 
    
    def formControl = [
        getControlList: {
            return controls;
        } 
    ] as FormPanelModel;    
}