package com.rameses.gov.etracs.bpls.reports.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;

public class BusinessMasterListReportModel extends AsyncReportController {

    @Script('BusinessReportUtil') 
    def businessReportUtil;
    
    @Script('ReportPeriod') 
    def periodUtil; 

    @Service('BarangayLookupService') 
    def brgySvc;

    @Service('BusinessMasterListReportService')
    def svc; 

    @Service('BusinessPermitTypeService') 
    def permitTypeSvc; 

    @Service('DateService')
    def dateSvc; 

    String title = "Business Master List";
    String reportpath = 'com/rameses/gov/etracs/bpls/reports/'; 
    String reportName = reportpath + 'BusinessMasterList.jasper'; 


    def formControl = [
        getControlList: { 
            return [
                [type:'combo', caption:'Permit Type', name:'entity.permittype', required:true, items:'permitTypes',  expression:'#{item.title}', preferredSize:'0,20', captionWidth:130],
                [type:'combo', caption:'Category', name:'entity.category', items:'categoryList', expression:'#{item.name}', preferredSize:'0,20', captionWidth:130, required:true], 
                
                [
                    type:'checklist', caption:'App Type', name:'entity.apptypes', immediate:true, 
                    items:'entity.category.apptypes', itemExpression:'#{item.title}', 
                    selectionMode:'MULTIPLE', itemCount:3, captionWidth:130, 
                    depends:'entity.category', dynamic:true, preferredSize:'0,30' 
                ], 
                
                [type:'combo', caption:'Barangay', name:'entity.barangay', items:'barangaylist',  expression:'#{item.name}', preferredSize:'0,20', captionWidth:130] 
            ]; 
        } 
    ] as FormPanelModel; 

    
    def appTypeList = [
        [objid: 'NEW', title:'NEW'],
        [objid: 'RENEW', title:'RENEW'],
        [objid: 'RETIRE', title:'RETIRE']
    ];

    def categoryList = [
        [objid: 'ACTIVE', name:'Active', matchkey:'NEW|RENEW'],
        [objid: 'ACTIVE-WITH-PERMIT', name:'Active With Permit', matchkey:'NEW|RENEW'],
        [objid: 'ACTIVE-WITHOUT-PERMIT', name:'Active Without Permit', matchkey:'NEW|RENEW'],
        [objid: 'RETIRED', name:'Retired', matchkey:'RETIRE'],
        [objid: 'PROCESSING', name:'Processing', matchkey:'NEW|RENEW|RETIRE'],
        [objid: 'CANCELLED', name:'Cancelled', matchkey:'NEW|RENEW|RETIRE'],
        [objid: 'FOR-RENEWAL', name:'For Renewal', matchkey:'NEW|RENEW'], 
        [objid: 'DELINQUENT', name:'Delinquent', matchkey:'NEW|RENEW']
    ];
    
    
    def permitTypes;
    def serverYear; 
    def header; 
    
    def initReport() { 
        def outcome = super.initReport(); 
        permitTypes = permitTypeSvc.getList(); 
        categoryList.each{ c-> 
            c.apptypes = appTypeList.findAll{( it.objid.matches( c.matchkey ) )}
        }
        entity.category = categoryList.first(); 
        entity.permittype = ( permitTypes ? permitTypes : mn)    
        return outcome; 
    } 
    
    void buildReportData(entity, asyncHandler) { 
        svc.getReport( entity, asyncHandler );
    }
    
    void buildResult( data ) { 
        if ( !data.reportdata ) throw new Exception('No available record(s) that matches your criteria.');
        
        header = data.header;
    } 

    Map getParameters(){
        def m = ( header ? header : [:] ); 
        //m.PERIOD = "FOR THE YEAR "+ entity.year; 
        m.APPTYPE = entity.apptypes.collect{ it.objid }.join(', '); 
        m.BARANGAYNAME = ( entity.barangay? entity.barangay.name : '(ALL)' ); 
        
        def report_title_buffer = new StringBuilder(); 
        report_title_buffer.append("Business Master List - "); 
        report_title_buffer.append( entity.category?.name );         
        m.REPORT_TITLE = report_title_buffer.toString(); 
        return m;  
    } 

    List getBarangaylist() {
        return brgySvc.getList([:]);
    }
}
