package ireport.designer.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;

public class IReportDesignerPreferenceModel  {

    def homedir;
    def homedirpath;
    
    def tempdir;
    def tempdirpath;

    void init(){
        def props = IReportDesigner.config.properties;

        def ofile = null; 
        if ( props.get('ireport.home')) {
            ofile = new java.io.File( props.get('ireport.home')); 
        }
        setHomedir( ofile ); 

        ofile = null; 
        if ( props.get('report.tmpdir')) {
            ofile = new java.io.File( props.get('report.tmpdir')); 
        }
        setTempdir( ofile );
    }
    
    void setHomedir( value ) {
        this.homedir = value; 
        this.homedirpath = ( value ? value.canonicalPath : null ); 
    }
    
    void setTempdir( value ) {
        this.tempdir = value; 
        this.tempdirpath = ( value ? value.canonicalPath : null ); 
    }
    
    def save() {
        IReportDesigner.config.location = (homedirpath ? homedirpath : ""); 
        if ( homedirpath ) {
            System.getProperties().put("ireport.home", homedirpath); 
        } else {
            System.getProperties().remove("ireport.home"); 
        }

        IReportDesigner.config.workspaceDir = (tempdirpath ? tempdirpath : ""); 
        if ( tempdirpath ) {
            System.getProperties().put("report.tmpdir", tempdirpath); 
        } else {
            System.getProperties().remove("report.tmpdir"); 
        }
        
        return '_close';
    }
    
    void testLaunch() {
        def model = [] as IReportDesignerModel; 
        IReportDesigner.show( model ); 
    }
}