package com.rameses.seti2.models;
 
import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.*;


/**
* workunit properties
* cols = choose only columns from schema, in the order displayed separated by commas.
* allowCreate = if true create button will be displayed. default is true
* allowOpen = if true open button will be displayed. default is true
* allowDelete = if true delete button will be displayed. default is false
* 
* init action must be called.
*/
public class CrudListModel extends AbstractCrudModel {
        
    def selectedItem;
    def list;
    def adapter;
    
    def query = [:];
    def _findBy = [:];
    def criteriaList = [];
    def queryForm;
    def whereStatement;
    String searchText;
    String filterText;
    def cols = [];
    
    def onOpenHandler;
    
    List searchables;
    List orWhereList = [];

    String strCols;
    
    
    boolean allowShowPageTitle = true;
    
    
    private String _tag_;
    private String _cols_;
    private String _hiddenCols_;
    
    boolean _multiSelect; 
        
    String getFormType() {
        return 'list';
    }
    
    public def getEntityContext() {
        return selectedItem;
    }
    
    public def getFindBy() {
        return _findBy;
    }
    
    
    
    //overridables
    public void beforeQuery( def m ) {
    }
    
    public def beforeFetchNodes( def m ) {
        return null; 
    }

    // this is the columns definition for UI 
    // override this if you want to set column properties 
    // like width, minWidth, maxWidth, visible, etc....
    public def getColumnDefs() { 
        return null; 
    }    
    
    public void initColumn( def c ) {
        //do nothing
    }
    
    //this is dynamic filter added by a caller
    def _customFilter;
    
    public void setCustomFilter( def cf ) {
        _customFilter = cf;
    }
    
    public def getCustomFilter() {
        if( _customFilter ) return _customFilter;

        String s = invoker.properties.customFilter;
        if( s!=null ) {
            return [s, query];
        }

        s = workunit.info.workunit_properties.customFilter;
        if( s != null ) return [s, query];
        return null;
    }
    
    public def getTag() {
        if( _tag_ !=null) return _tag_;
        def t = invoker.properties.tag;
        if(t) return t;
        return workunit.info.workunit_properties.tag;
    }
    
    public void setTag(def s) {
        _tag_ = s;
    }
    
    public void setSelectColNames(def s) {
        _cols_ = s;
    }
    
    public def getSelectColNames() {
        if(_cols_ !=null) return _cols_;
        def t = invoker.properties.cols;
        if(t) return t;
        return workunit.info.workunit_properties.cols;    
    }
    
    public void setHiddenCols(def s) {
        _hiddenCols_ = s;
    }
    
    public def getHiddenCols() {
        if(_hiddenCols_!=null) return _hiddenCols_;
        def t = invoker.properties.hiddenCols;
        if(t) return t;
        return workunit.info.workunit_properties.hiddenCols;    
    }
    
    private def _schema;
    public def getSchema() {
        if( _schema !=null ) return _schema;
        
        strCols = getSelectColNames();
        
        //this is for hidden columns
        
        if(!schemaName) 
            throw new Exception("Please specify a schema name in the workunit");
        
        if(!adapter) {
            adapter = workunit.info.workunit_properties.adapter; 
        }
        
        def map = [name:schemaName, adapter: adapter]; 
        //map.debug = true;
        if ( !strCols ) {
            map.colnames = strCols;
            if(hiddenCols) map.colnames = strCols + ","+hiddenCols;
        }
        
        _schema = getPersistenceService().getSchema( map );
        
        if(!strCols) {
            strCols = _schema.fields.findAll{ it.visible != "false" }*.name.join(",");
        }
        
        _schema.name = schemaName;
        if(adapter) _schema.adapter = adapter;
        
        def smatch = strCols?.replace(",","|");
        def nmatch = hiddenCols?.replace(",", "|");
        _schema.fields.each {
            it.selected = false;
            if(nmatch && it.name.matches(nmatch)) it.selected = false;
            if(smatch && it.name.matches(smatch) ) it.selected = true;
        }

        
        return _schema;
    }
    //end overridables
    

    def sorter;
    public String getOrderBy() {
        if(!sorter) {
            String s = invoker.properties.orderBy;
            if( s ) return s;
            return workunit.info.workunit_properties.orderBy;            
        }
        else {
            return sorter.name + " " + sorter.order;
        }
    }
    
    def sort() {
        def opMenu = new PopupMenuOpener();  
        columnList.each {
            def cap = it.caption;
            if(sorter?.name == it.name) {
                cap += (sorter.order=="ASC") ? " ^" : " v";
            }
            opMenu.add( new PopupAction( caption:cap, 
            name: "fireSort" ,obj: this, parameters: [name: it.name]) )    
        }
        return opMenu;  
    }

    void fireSort(def p ) {
        if(!sorter) sorter = [order:"ASC"];
        sorter.name = p.name;
        sorter.order = (sorter.order == "ASC")? "DESC" : "ASC";
        reload();
    }

    boolean isSurroundSearch() {
        String s = invoker?.properties?.surroundSearch;
        if ( !s ) s = workunit?.info?.workunit_properties?.surroundSearch;
        return (s.toString().equals("false")? false: true); 
    }
           
    boolean isAllowSearch() {
        return (searchables);
    }
    
    void beforeInit(){}
    void afterInit(){}
    
    boolean _inited_ = false;
    void init() {
        if(_inited_ ) return;
        
        beforeInit();
        //load role and domain if any.
        if( pageExists("queryForm")) {
            queryForm = new Opener(outcome:'queryForm')
        }
        super.initRole();
        
        schema = getSchema();
        cols.clear();
        for( it in  schema.fields) {  
            if(it.jointype) continue;
            if ( it.primary==true ) {
                if( it.source != schema.name ) {
                    it.visible = false;
                    it.hidden = 'true'
                }
                else {
                    it.selectable = true;
                    it.selected = ( it.visible=='true' ); 
                }
            }
            /* 
            else if ( it.visible==null || it.visible=='true' ) {
                it.selected = true; 
            } 
            */
            if ( !it.caption ) it.caption = it.name; 
            cols << it; 
        }

        searchables = schema.fields.findAll{ it.searchable == "true" }*.name;
        if ( searchables == null ) searchables = [];
        
        _inited_ = true;
        
        afterInit();
    } 

    public void beforeBuildSelectQuery( Map query ) {
    }
    
    public def buildSelectQuery(Map o) {
        return buildSelectQuery(o, true);
    }
    
    public def buildSelectQuery(Map o, boolean sincludeFields) {
        def m = [:];
        if(o) m.putAll(o);
        if(query) {
            m.putAll(query);
        } 
        
        beforeBuildSelectQuery( m ); 
        
        //place the orgid and userid immediately in the query.
        if( query !=null && !query.orgid) {
            query.orgid = OsirisContext.env.ORGID;
        }
        if( query !=null && !query.userid) {
            query.userid =  OsirisContext.env.USERID;
        }
        
        if(getFindBy()) {
            m.findBy = getFindBy();
        }
        m._schemaname = schema.name;
        m.adapter = schema.adapter;
        
        if( sincludeFields ) {
            def primKeys = cols.findAll{it.primary==true && it.source==schema.name}*.name;
            //def arr = cols.findAll{ it.hidden=='true' || it.selected==true }*.name; 
            //build the columns to retrieve
            def arr = cols*.name;
            m.select = (primKeys + arr).unique().join(",") ;
        }

        def s1 = [];
        def s2 = [:];
        if( whereStatement!=null ) {
            s1 << whereStatement[0];
            s2.putAll( whereStatement[1]);
        }
        def xFilter = getCustomFilter();
        if(xFilter!=null) {
            s1 << xFilter[0]
            if( xFilter.size() > 1 ) {
                s2.putAll( xFilter[1] );
            }
        }
        if( s1 ) {
            m.where = [ s1.join(" AND "), s2];
        }
        
        if( orWhereList.size() > 0 ) {
            m.orWhereList = orWhereList;
        }
        if( getTag()!=null ) {
            m._tag = getTag();
        }  
        if(sincludeFields ) {
            if( !ValueUtil.isEmpty(getOrderBy()) ) {
                m.orderBy = getOrderBy();
            }
        }
        beforeQuery( m );
        return m;
    }
    
    public int getRows() {
        return 20;
    }
    
    public void setMultiSelect( boolean b ) { 
        this._multiSelect = b; 
    } 
    
    public boolean getMultiSelect() {
        def g = invoker.properties.multiSelect;
        if(!g) {
            g = workunit.info.workunit_properties.multiSelect;
        }
        if(g) {
            try {
                return Boolean.parseBoolean( g );
            }
            catch(Exception ign){;}
        }
        return this._multiSelect;
    }
    
    public boolean isAutoResize() { 
        return true; 
    }
    
    Number convertNumber( Object value ) {
        try { 
            if ( value instanceof Number ) return value; 
 
            return new Long( value.toString());
        } catch(Throwable t) {
            return null; 
        } 
    }

    //These are overridable methods
    public def getColumnList() {
        if( schema == null )
            throw new Exception("schema is null. Please call init method")
        def zcols = [];
        //always add the primary keys
        //String matcher = ".*";
        //if(strCols) matcher = strCols.replace(",","|");
        //def selCols = cols.findAll{it.selected == true &&  it.name.matches(matcher)};
        def selCols = cols.findAll{it.selected == true };
        int maxSz = selCols.size();
        for( c in selCols ) {
            def cc = [:];
            cc.putAll( c );
            if(c.datatype) {
                cc.type = c.datatype;
            }
            cc.colindex = maxSz;

            def num = convertNumber( cc.width ); 
            if ( num != null ) cc.width = num.intValue();

            num = convertNumber( cc.minWidth ); 
            if ( num != null ) cc.minWidth = num.intValue();

            num = convertNumber( cc.maxWidth ); 
            if ( num != null ) cc.maxWidth = num.intValue();

            initColumn( cc );
            zcols << cc;
        }
        //sort the columns based on the order in strCols
        int i = 0;
        if( strCols ) {
            def arr = (strCols+","+hiddenCols).split(",");
            for( ss in arr ) {
                def g = zcols.find{ it.name == ss.trim() }
                if( g ) g.colindex = (i++);
            }
        }
        zcols = zcols.sort{ it.colindex };
        return zcols;    
    }
    
    public def fetchList(def o ) {
        if( schema == null )
            throw new Exception("schema is null. Please call invoke method")
        if(!_inited_) throw new Exception("This workunit is not inited. Please call init action");
        def m = buildSelectQuery(o);
        m._connection = getConnection();
        return getQueryService().getList( m );     
    }
    
    final def _self = this; 
    def listHandler = [ 
        isAutoResize  : {
            return _self.isAutoResize(); 
        }, 
        isMultiSelect : {
            return getMultiSelect(); 
        }, 
        getRows : {
            return getRows();
        },
        getColumnList: {
            return getColumnList();
        },
        fetchList: { o->
            return fetchList(o);
        },
        onOpenItem: { o, colName -> 
            if( onOpenHandler ) return onOpenHandler( o, colName );
            
            try {
                return open();  
            }
            catch(e) {
                return null;
            }
        }
    ] as PageListModel;
   
    void buildSearchFilter() {
        orWhereList.clear();
        listHandler.searchtext = searchText;
        if( searchText ) {
            def st = searchText+"%";
            if ( isSurroundSearch() ) { 
                st = "%"+st; 
            }
            if ( searchables ) {
                searchables.each { 
                    orWhereList << [ it + " like :searchtext", [ searchtext: st ]]; 
                } 
            }
        } 
    }
    
    void search() {
        buildSearchFilter();
        boolean hasNodes = reloadNodes();
        if(!hasNodes) listHandler.doSearch();
    }
    
    //returns the where element
    def buildWhereStatement() {
        def buff = new StringBuilder();
        def params = [:]
        int i = 0;
        for( c in criteriaList*.entry ) {
            def dtype = c.field.type;
            if ( dtype == null ) dtype = "string";
            def op = c[(dtype+'operator')];
            if(i++>0) buff.append( " AND ");
            buff.append( c.field.name + ' ' + op.key + ' :' +c.field.extname );
            params.put( c.field.extname, c.value );
            if( op.key?.toUpperCase() == 'BETWEEN') {
                buff.append( " AND :"+c.field.extname+"2" );
                params.put( c.field.extname+"2", c.value2 );
            }
        };
        return [buff.toString(), params];
    }
        
    def showFilter() {
        def h = { o->
            criteriaList.clear();
            criteriaList.addAll( o );     
            if( criteriaList.size() > 0 ) {
                whereStatement = buildWhereStatement(); 
                filterText = buildFilterText();
            }
            else {
                whereStatement = null;       
                filterText = null;
            }
            //we call doSearch to set the start at 0
            boolean hasNodes = reloadNodes();
            if(!hasNodes) listHandler.doSearch();

            binding.refresh('filterText');
            binding.notifyDepends('toolbar'); 
            binding.notifyDepends('header'); 
        }
        return Inv.lookupOpener( "crud:showcriteria", [cols: cols, handler:h, criteriaList: criteriaList] );
    }

    def buildFilterText() {
        if (!whereStatement || whereStatement[0].trim().length() == 0) 
            return null;
        def str = whereStatement[0]
        def params = whereStatement[1]
        params.each{k,v ->
            if (v)
                str = str.replace(':'+k, v)
        }
        return 'Criteria: ' + str 
    }    
            
    def selectColumns() {
        def h = {
            listHandler.reloadAll();
        }
        //def c = cols.findAll{ it.selectable != 'false' }
        def c = schema.fields.findAll{ !it.hidden };
        return Inv.lookupOpener( "crud:selectcolumns", [columnList: c, onselect:h] );
    }
    
    def create() {
        def ename = ( entitySchemaName ? entitySchemaName : schemaName);
        def p = [ schemaName:ename, adapter:adapter];
        p.title = "New " + workunit.title; 
        p.callbackListHandler = listHandler; 
        p.callbackListModel = this;

        def d = null;
        try {
            d = Inv.lookupOpener( ename + ":create", p );
        } catch(Throwable t) {
            // do nothing 
        }
        if ( !d ) throw new Exception("No handler found for . " + ename + ".create. Please check permission");
        if ( !d.target ) d.target = 'window';
        return d;
    }

    def close() {
        if ( closeHandler ) { 
            closeHandler(); 
            return null; 
        }
        return "_close"; 
    }
    
    def open() {
        if ( !isOpenAllowed() )
            throw new Exception("Open not allowed");
        if( !selectedItem ) 
            throw new Exception("Please select an item");

        def ename = (entitySchemaName ? entitySchemaName : schemaName);
        def p = [ schemaName:ename, adapter:adapter, entity: selectedItem];
        p.title = "Open " + workunit.title;
        p.callbackListHandler = listHandler; 
        p.callbackListModel = this;
        
        def d = null;
        try {
            d = Inv.lookupOpener( ename + ":open", p );
        } catch(Throwable t) {
            // do nothing 
        }
        if ( !d ) throw new Exception("No handler found for . " + ename + ".open. Please check permission");
        if ( !d.target ) d.target = 'window';
        return d;
    }
    
    void beforeRemoveItem() {}
    void afterRemoveItem() {}
    
    void removeEntity() {
        if(!selectedItem) return;

        if(!this.isDeleteAllowed()) 
            throw new Exception("Delete is not allowed for this transaction");
        if( selectedItem.system != null && selectedItem.system == 1 )
            throw new Exception("Cannot remove system created file");
            
        try {
            beforeRemoveItem(); 
        } catch(BreakException be) { 
            return; 
        } 
        
        if( !MsgBox.confirm('You are about to delete this record. Proceed?')) return;
        def m = [:];
        def ename = (!entitySchemaName)? schemaName : entitySchemaName;
        m._schemaname = ename;
        //show only primary key of the main element.
        schema.fields.findAll{it.primary}.each {
            if( entitySchemaName !=null ||  it.source == ename ) {
                m.put( it.name, selectedItem.get(it.name));
            }
        }
        getPersistenceService().removeEntity( m );
        boolean hasNodes = reloadNodes();
        if(!hasNodes) listHandler.reload();
        
        try {
            afterRemoveItem(); 
        } catch(BreakException be) { 
            // do nothing 
        }         
    }
    
    /*
    void refresh() {
        reload();
    }
    */
    
    void reload() {
        boolean hasNodes = reloadNodes();
        if(!hasNodes) {
            listHandler.reload();
        }
    }
    
    //if returns true, do not reload the list.  
    boolean reloadNodes(){
        if(nodeListHandler) {
            nodeListHandler.reload();
        }
        if(_nodeList) return true;
        else return false;
    }
    
    def print() {
        //load first all data.
        def m = buildSelectQuery([:]);
        int i = 0;
        def buffList = [];
        while( true ) {
            m._start = i;
            m._limit = 50;
            def l = getQueryService().getList( m );
            buffList.addAll( l );
            if( l.size() < 50  ) {
                break;
            }
            i=i+50;
        }
        def reportModel = [
            title: getTitle(),
            columns : cols.findAll{ it.selected == true }
        ]
        return Inv.lookupOpener( "dynamic_report:print", [reportData:buffList, reportModel:reportModel] );
    }
    
    //if there are nodes
    def _nodeList;
    private def _selectedNode;


    final def nodeListHandler = [
        fetchList : { 
            _nodeList = null;
            return getNodeList();
        },
        onselect: { o-> 
            listHandler.doSearch();
        }
    ] as ListPaneModel 

    
    //overridable source
    public def fetchNodeList(def m) {
        return queryService.getNodeList(m);
    }
    
    def getNodeList() {
        if(!_nodeList) {
            def m = [:];
            m = buildSelectQuery( m, false );
            /*
            def m = [:];
            m._schemaname = schema.name;
            m.adapter = schema.adapter;   
            String _tag_ = getTag();
            if( _tag_ ) m._tag = _tag_;
            buildSelectQuery(m);
            m.remove("select");
            m.remove("order")
            def wf = buildWhereStatement();
            if( wf[0] ) m.whereFilter = wf;
            if(orWhereList) m.orWhereList = orWhereList;
            */
            beforeFetchNodes( m );
            _nodeList = fetchNodeList( m );
        }
        return _nodeList;
    }
    
    void setSelectedNode(def n) {
        _selectedNode = n;
        query.put("node", n);
    }
    
    def getSelectedNode() {
        return _selectedNode;
    }    
    
    /**************************************************************************
    //additional code for download and upload
    ***************************************************************************/
    @Service("SyncService")
    def syncService;
    
    public boolean isShowSyncDownload() {
        def showDownload = invoker.properties.showSyncDownload;
        if(!showDownload) showDownload = workunit.info.workunit_properties.showSyncDownload;        
        if( showDownload ) {
            if (showDownload == 'true') return true;
        }
        return false;
    } 
    
    public boolean isShowSyncUpload() {
        def showUpload = invoker.properties.showSyncUpload;
        if(!showUpload) showUpload = workunit.info.workunit_properties.showSyncUpload;        
        if( showUpload ) {
            if (showUpload == 'true') return true;
        }
        return false;
    }

    public void syncPush() {
        syncService.push( [_schemaname: getSchemaName() ] );
        MsgBox.alert("Sync Finished");
    }
    
    public void syncPull() {
        syncService.pull( [_schemaname: getSchemaName() ] );
        this.reload();
        MsgBox.alert("Sync Finished");        
    }
}
