package com.rameses.seti2.models;
 
import com.rameses.common.*;
import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;
import com.rameses.rcp.constant.*;
import java.rmi.server.*;
import com.rameses.util.*;

public class SimpleListLookupModel implements SimpleLookupDataSource {

    @Binding
    def binding;
    
    String title;
    def selectedItem;
    def listHandler;
    def onselect;

    def lookupSelector;
    
    public void setSearchText(String searchtext) {
        //throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public void setSelector(LookupSelector selector) {
        lookupSelector = selector;
    }
    
    def doOk() {
        if(!onselect) throw new Exception("Please specify onselect" );
        def retval = null;
        if( !listHandler.isMultiSelect() ) {
            retval = onselect( selectedItem );
        }
        else {
            retval = onselect( listHandler.selectedValue );
        }
        if(retval) {
            if ( retval instanceof String || retval instanceof Opener ) { 
                binding.fireNavigation( retval ); 
            } 
        }
        return "_close";
    }

    def doCancel() {
        return "_close";
    }
  
}
        