package com.rameses.gov.etracs.landtax.models;

import com.rameses.rcp.common.*
import com.rameses.rcp.annotations.*
import com.rameses.osiris2.client.*
import com.rameses.osiris2.reports.*
import java.rmi.server.UID;

public class CapturePreviousPaymentModel extends CapturePaymentModel  
{
    void createPrevious() {
        super.create();
        def oldestpmt = svc.getOldestPayment([objid: payment.refid]);
        payment.putAll(oldestpmt);
        mode = 'previous-pmt';
    }

        
    def ok() {
        validate();    
        calcTotal();
        if( MsgBox.confirm('Posted previous payment could no longer be edited.\nPlease verify the information is correct.\n\nPost?') ) {
            svc.postPreviousPayment(payment)
            caller.reloadEntity();
            caller.refreshSections();
            return '_close' 
        }
        return 'default' 
    }
    
}