package com.rameses.gov.etracs.landtax.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;

class CreateMissingLedgerModel 
{
    @Binding
    def binding;
    
    @Service('RPTLedgerService') 
    def svc;

    String title = 'Create Missing Ledger';
    
    def entity = [:];


    def create() {
        if (!MsgBox.confirm('Create missing ledger?')) return;
        svc.createMissingLedger(entity.faas);
        MsgBox.alert('Ledger has been successfully created.');
        return "_close";
    }

    def getLookupFaas() {
        return Inv.lookupOpener('faas:lookup', [
            onselect: {
                if (!'CURRENT'.equalsIgnoreCase(it.state)) 
                    throw new Exception('Selected FAAS is invalid. Only current state is allowed.')

                entity.faas = it;
            },
            onempty: {
                entity.faas = null;
            }
        ])
    }

}