package com.rameses.gov.etracs.landtax.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.common.AsyncHandler;

class RepostRealPropertTaxShareModel
{
    @Binding
    def binding;
    
    @Service('DateService')
    def dtSvc;
    
    @Service('RepostRealPropertTaxShareService')
    def svc;
    
    def asyncHandler;
    def has_result_preview = false; 
    def msg;
    def mode = 'init';
    
    def entity;
    def months;
    def processing = false;
    def totalItemsForPosting = 0;
    def receipttypes = ['ONLINE', 'EOR'];
    
    def init() {
        def pdate = dtSvc.parseCurrentDate();
        entity = [:];
        entity.startyear = pdate.year;
        entity.endyear = entity.startyear;
        entity.startmonth = getMonths().find{it.index == pdate.month};
        entity.endmonth = entity.startmonth;
        
        def remainingCount = svc.getRemainingCount();
        if (remainingCount > 0) {
            if (MsgBox.confirm('There are still unposted receipts. Continue?')) {
                progressHandler.setMaxValue(remainingCount);
                new Thread(task).start();
                return 'default';
            }
        } 
        
        return 'init';
    }

    def progressHandler = [
        getMinValue: { 0 },
    ] as ProgressModel;

    def repostShares() {
        if (entity.startyear > entity.endyear) 
        throw new Exception('Start Year must be less than or equal to End Year.');

        if (entity.startyear == entity.endyear && entity.startmonth.index > entity.endmonth.index) 
        throw new Exception('Start Month must be before or equal to End Month.');
        
        asyncHandler = [
            onError: {o-> 
                MsgBox.err(o.message); 
                processing = false;
                binding.refresh(); 
            }, 
            onTimeout: {
                asyncHandler.retry(); 
            },
            onCancel: {
                processing = false;
                binding.refresh();
            }, 
            onMessage: {o-> 
                if (o == com.rameses.common.AsyncHandler.EOF) {
                    if (!has_result_preview) {
                        processing = false;
                        binding.refresh(); 
                    } 
                    
                } else if (o instanceof Throwable) { 
                    MsgBox.err(o.message); 
                    asyncHandler.cancel();
                    processing = false;
                    binding.refresh();
                } else {
                    totalItemsForPosting = o;     
                    has_result_preview = true; 
                    mode = 'posting';
                    if (totalItemsForPosting > 0) {
                        progressHandler.setMaxValue(totalItemsForPosting);
                        new Thread(task).start();
                        binding.fireNavigation('default'); 
                    } else {
                        mode = 'init';
                        processing = false;
                        binding.refresh();
                        MsgBox.alert('There are no receipts to repost.');
                    }
                }
            } 
        ] as com.rameses.common.AbstractAsyncHandler 
        
        has_result_preview = false;
        svc.buildReceiptsToRepost(entity, asyncHandler);
        mode = 'init';
        processing = true;
        msg = 'Posting receipt shares. Please wait...';
        return null;
    }

    def getMonths() {
        if (!months) {
            months = dtSvc.getMonths();
        }
        return months;
    }

    def task = [
        run: {
            def items = svc.getReceiptsToRepost(); 
            totalItemsForPosting = items.size();
            progressHandler.setMaxValue(totalItemsForPosting);
            def value = 0;
            while(items.size() > 0) {
                def item = items.remove(0);
                svc.postShare(item);
                progressHandler.setValue(++value);
                sleep(200);
            }
            progressHandler.setValue(progressHandler.getMaxValue());
            mode = 'init';
            processing = false;
            binding.fireNavigation('init');
            binding.refresh('msg');
            MsgBox.alert('Shares has been successfully reposted');
        }
    ] as Runnable

    void sleep(ms) {
        try { 
            Thread.sleep(ms);
        } catch(ex) {
            //
        }
    }
}