package bpls.online.models;

import com.rameses.rcp.annotations.*;
import com.rameses.rcp.common.*;
import com.rameses.osiris2.common.*;
import com.rameses.osiris2.client.*;
import com.rameses.seti2.models.CrudFormModel;
import java.awt.KeyboardFocusManager;
import javax.swing.JFileChooser;

class OnlineBusinessApplicationModel extends CrudFormModel {

    @Service('OnlineBusinessApplicationService') 
    def appSvc;
    
    @Service('OnlineBusinessApplicationDocService') 
    def appDocSvc;
    
    @Service('SysFileService') 
    def fileSvc;
    
    def selectedRequirement;
    
    public void afterOpen(){
        if ( entity.infos ) {
            def malecount = toInteger( entity.infos.find{( it.name == 'NUM_EMPLOYEE_MALE')}?.value );
            def femalecount = toInteger( entity.infos.find{( it.name == 'NUM_EMPLOYEE_FEMALE')}?.value );
            def totalcount = (malecount ? malecount : 0) + (femalecount ? femalecount : 0); 
            entity.infos << [ 
                name: 'NUM_EMPLOYEE', caption:'NO. OF EMPLOYEES', 
                datatype: 'integer', value: totalcount 
            ]; 
        }
        
        if ( entity.requirements ) {
            entity.requirements.each{
                it.hasattachment = ( it.attachment?.location ? true : false );
            }
        }
        
        if ( binding ) {
            binding.notifyDepends('formActions'); 
        }
    }
    
    def toInteger( value ) {
        try {
            if ( value instanceof Number ) {
                return value; 
            }
            return value.toInteger(); 
        } catch(Throwable t) {
            return null; 
        }
    }
        
    def lobListHandler = [
        fetchList: {
            entity.lobs; 
        }
    ] as DataListModel;

    def infoListHandler = [
        fetchList: {
            entity.infos; 
        }
    ] as DataListModel;

    def requirementListHandler = [
        fetchList: {
            entity.requirements; 
        }
    ] as DataListModel;

    
    boolean isWithAttachment() {
        return (selectedRequirement?.docid ? true : false); 
    }
  
    void downloadAttachment() {
        if ( !isWithAttachment() ) return; 
        
        def docid = selectedRequirement.docid; 
        def doc = appDocSvc.open([ objid: docid ]); 
        if ( doc ) {
            def dd = doc.download; 
            if ( dd ) {
                def buff = new StringBuilder(); 
                buff.append("The selected attachment has already been scheduled for download");
                
                if ( dd.progress ) {
                    buff.append(" with ").append( dd.progress ).append(" in progress"); 
                }
                
                MsgBox.alert( buff.toString());
                return; 
            }
            
            def state = doc.fs?.state; 
            if ( state.toString().toUpperCase() != 'COMPLETED' ) {
                MsgBox.alert( "Download sync status is "+ state.toString().toLowerCase());
                return; 
            }
        }
        else { 
            MsgBox.alert( "Failed to locate doc-id reference for this attachment"); 
            return; 
        } 
        
        // proceed to the download process
        def file = fileSvc.read([ objid: doc.fs?.fileid ]); 
        if ( !file ) {
            MsgBox.alert("Failed to locate file-id reference for this attachment");
            return; 
        }
        
        def win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if ( win == null ) {
            win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(); 
        }
        
        def jfc = new JFileChooser();
        jfc.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY ); 
        jfc.setDialogTitle("Select Download Folder");
        jfc.setMultiSelectionEnabled( false );
        int opt = jfc.showOpenDialog( win ); 
        if ( opt != JFileChooser.APPROVE_OPTION ) {
            return; 
        } 
        
        def dir = jfc.getSelectedFile();
        dir = new java.io.File( dir, entity.bin ); 
        
        def sfilename = [ entity.bin, doc.attachment.objid, doc.attachment.name ].join("_");
        def targetFile = new java.io.File( dir, sfilename ); 
        
        def fileitem = file.items.first();
        def opparam = [ fileitem: fileitem, connection: 'bpls', targetFile: targetFile ];

        opparam.oncomplete = {
            def buff = new StringBuilder();
            buff.append("Attachment successfully downloaded."); 

            if ( java.awt.Desktop.isDesktopSupported()) {
                buff.append(" Do you want to open the file?"); 

                boolean b = MsgBox.confirm( buff.toString()); 
                if ( b ) { 
                    java.awt.Desktop.getDesktop().open( targetFile ); 
                }
            }
            else {
                MsgBox.alert( buff.toString());
            }
        }
        
        def opener = Inv.lookupOpener('sys_fileitem:download', opparam); 
        if ( opener ) {
            opener.target = "process"; 
            Inv.invoke( opener ); 
        }
    }
    
    def viewAttachment() {
        if ( !isWithAttachment() ) return null; 
        
        def docid = selectedRequirement.docid; 
        def doc = appDocSvc.open([ objid: docid ]); 
        if ( doc ) {
            def dd = doc.download; 
            if ( dd ) {
                def buff = new StringBuilder(); 
                buff.append("Download in progress ...");
                
                if ( dd.progress ) {
                    buff.append( dd.progress ); 
                }
                
                MsgBox.alert( buff.toString());
                return null; 
            }
            
            def file = fileSvc.read([ objid: doc.fs?.fileid ]); 
            if ( !file ) {
                MsgBox.alert("Failed to locate file-id reference for this attachment");
                return null; 
            }
            
            def fileitem = file.items.first();
            def opener = Inv.lookupOpener('sys_fileitem:open', [fileitem: fileitem, connection: 'bpls']); 
            if ( opener ) opener.target = "popup"; 
            
            return opener;
        } 
        else { 
            MsgBox.alert( "Failed to locate doc-id reference for this attachment"); 
            return null;             
        }       
    }
    
    void approve() {
        if ( MsgBox.confirm('You are about to submit this application for processing.\nDo you want to continue?')) {
            def docs = appDocSvc.getPendingDocs([ applicationid: entity.objid ]); 
            if ( docs ) {
                boolean pass = MsgBox.confirm('Some attachments are still in download progress.\nDo you want to continue?')
                if ( !pass ) return; 
            }
            
            def res = appSvc.approve([ objid: entity.objid ]); 
            if ( res?.state ) entity.state = res.state; 
        }
    }
} 