package com.rameses.gov.etracs.bpls.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.common.*;

class BplsRecurringFeeModel {
    
    def task;
    def entity;
    def handler
    def mode;

    @PropertyChangeListener
    def listener = [
        "entity.txntype" : { o->
            entity.account = o.account;
            entity.txntypeid = o.objid;
        }
    ];

    void create() {
        entity = [:];
        mode = 'create'
    }

    void open() {
        mode = 'edit'
    }

    def doOk() {
        if( handler) handler(entity);
        return "_close";
    }

    def doCancel() {
        return "_close";
    }

    def getLookupHandler() {
        def param = [:];
        param.put('query.role', task?.role ); 
        param.put('query.domain', task?.domain ); 
        return Inv.lookupOpener("business_billitem_txntype:lookup", param);
    }    
}
        