package com.rameses.gov.etracs.landtax.models;

import com.rameses.rcp.common.*;
import com.rameses.rcp.annotations.*;
import com.rameses.osiris2.client.*;
import com.rameses.osiris2.reports.*;


class LandTaxReportFaasMasterListModel extends com.rameses.gov.etracs.rpt.report.AsyncReportController
{
    @Service('LandTaxReportFaasMasterListService') 
    def svc 
    
    String title = 'FAAS Master List'
    
    String reportName = 'com/rameses/gov/etracs/landtax/reports/faas_master_list.jasper';
    
    void buildReportData(entity, asyncHandler){
        svc.getReportData(entity, asyncHandler);
    }
    
    Map getParameters(){
        return data.parameters;
    }    
    
    def formControl = [
        getFormControls: {
            return [
                new FormControl( "integer", [captionWidth:100, caption:'Year', name:'entity.year', required:true]),
                new FormControl( "combo", [captionWidth:100, caption:'Month', name:'entity.month', required:false, emptyText:'ALL', items:'months', expression:'#{item.caption}']),
                new FormControl( "combo", [captionWidth:100, caption:'LGU', name:'entity.lgu', items:'lgus', expression:'#{item.name}', emptyText:'ALL', allowNull:true]),
                new FormControl( "combo", [captionWidth:100, caption:'Barangay', name:'entity.barangay', items:'barangays', expression:'#{item.name}', depends:'entity.lgu', dynamic:true, preferredSize:'0,21', emptyText:'ALL']),
                new FormControl( "combo", [captionWidth:100, caption:'Property Type', name:'entity.rputype', items:'rpuTypes', required:false, immediate:true, emptyText:'ALL']),
                new FormControl( "combo", [captionWidth:100, caption:'Classification', name:'entity.classification', items:'classifications', immediate:true, expression:'#{item.name}', emptyText:'ALL']),
                new FormControl( "combo", [captionWidth:100, caption:'Taxability', name:'entity.taxability', items:'taxabilities', immediate:true, emptyText:'ALL']),
                new FormControl( "combo", [captionWidth:100, caption:'Order By', name:'entity.orderby', items:'orderbyColumns', expression:'#{item.caption}']),
            ]    
        },
   ] as FormPanelModel;
   
   
   def orderbyColumns = [
        [fieldname:'owner_name, tdno', caption:'Owner Name'],
        [fieldname:'pin, tdno', caption:'PIN'],
        [fieldname:'tdno', caption:'TD No.'],
    ]
}
